/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.census.internal.ObservabilityCensusConstants;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import io.opencensus.trace.SpanContext;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public final class InternalLoggingChannelInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(InternalLoggingChannelInterceptor.class.getName());
    private final LogHelper helper;
    private final ConfigFilterHelper filterHelper;

    private InternalLoggingChannelInterceptor(LogHelper helper, ConfigFilterHelper filterHelper) {
        this.helper = helper;
        this.filterHelper = filterHelper;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final AtomicLong seq = new AtomicLong(1L);
        final String callId = UUID.randomUUID().toString();
        final String authority = next.authority();
        final String serviceName = method.getServiceName();
        final String methodName = method.getBareMethodName();
        final Deadline deadline = LogHelper.min(callOptions.getDeadline(), Context.current().getDeadline());
        final SpanContext clientSpanContext = (SpanContext)callOptions.getOption(ObservabilityCensusConstants.CLIENT_TRACE_SPAN_CONTEXT_KEY);
        ConfigFilterHelper.FilterParams filterParams = this.filterHelper.logRpcMethod(method.getFullMethodName(), true);
        if (!filterParams.log()) {
            return next.newCall(method, callOptions);
        }
        final int maxHeaderBytes = filterParams.headerBytes();
        final int maxMessageBytes = filterParams.messageBytes();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Duration timeout = deadline == null ? null : Durations.fromNanos((long)deadline.timeRemaining(TimeUnit.NANOSECONDS));
                try {
                    InternalLoggingChannelInterceptor.this.helper.logClientHeader(seq.getAndIncrement(), serviceName, methodName, authority, timeout, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.CLIENT, callId, null, clientSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log request header", e);
                }
                ForwardingClientCallListener.SimpleForwardingClientCallListener observabilityListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        try {
                            InternalLoggingChannelInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventType.SERVER_MESSAGE, message, maxMessageBytes, GrpcLogRecord.EventLogger.CLIENT, callId, clientSpanContext);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Unable to log response message", e);
                        }
                        super.onMessage(message);
                    }

                    public void onHeaders(Metadata headers) {
                        try {
                            InternalLoggingChannelInterceptor.this.helper.logServerHeader(seq.getAndIncrement(), serviceName, methodName, authority, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.CLIENT, callId, LogHelper.getPeerAddress(this.getAttributes()), clientSpanContext);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Unable to log response header", e);
                        }
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            InternalLoggingChannelInterceptor.this.helper.logTrailer(seq.getAndIncrement(), serviceName, methodName, authority, status, trailers, maxHeaderBytes, GrpcLogRecord.EventLogger.CLIENT, callId, LogHelper.getPeerAddress(this.getAttributes()), clientSpanContext);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Unable to log trailer", e);
                        }
                        super.onClose(status, trailers);
                    }
                };
                super.start((ClientCall.Listener)observabilityListener, headers);
            }

            public void sendMessage(ReqT message) {
                try {
                    InternalLoggingChannelInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventType.CLIENT_MESSAGE, message, maxMessageBytes, GrpcLogRecord.EventLogger.CLIENT, callId, clientSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log request message", e);
                }
                super.sendMessage(message);
            }

            public void halfClose() {
                try {
                    InternalLoggingChannelInterceptor.this.helper.logHalfClose(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventLogger.CLIENT, callId, clientSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log half close", e);
                }
                super.halfClose();
            }

            public void cancel(String message, Throwable cause) {
                try {
                    InternalLoggingChannelInterceptor.this.helper.logCancel(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventLogger.CLIENT, callId, clientSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log cancel", e);
                }
                super.cancel(message, cause);
            }
        };
    }

    public static class FactoryImpl
    implements Factory {
        private final LogHelper helper;
        private final ConfigFilterHelper filterHelper;

        public FactoryImpl(LogHelper helper, ConfigFilterHelper filterHelper) {
            this.helper = helper;
            this.filterHelper = filterHelper;
        }

        @Override
        public ClientInterceptor create() {
            return new InternalLoggingChannelInterceptor(this.helper, this.filterHelper);
        }
    }

    public static interface Factory {
        public ClientInterceptor create();
    }
}

