/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.ClientInterceptor;
import io.grpc.InternalGlobalInterceptors;
import io.grpc.ServerInterceptor;
import io.grpc.ServerStreamTracer;
import io.grpc.census.InternalCensusStatsAccessor;
import io.grpc.census.InternalCensusTracingAccessor;
import io.grpc.census.internal.ObservabilityCensusConstants;
import io.grpc.gcp.observability.ObservabilityConfig;
import io.grpc.gcp.observability.ObservabilityConfigImpl;
import io.grpc.gcp.observability.interceptors.ConditionalClientInterceptor;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.InternalLoggingChannelInterceptor;
import io.grpc.gcp.observability.interceptors.InternalLoggingServerInterceptor;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.gcp.observability.logging.GcpLogSink;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.gcp.observability.logging.TraceLoggingHelper;
import io.opencensus.common.Duration;
import io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsExporter;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceConfiguration;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceExporter;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.stats.Stats;
import io.opencensus.stats.ViewManager;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.config.TraceConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class GcpObservability
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(GcpObservability.class.getName());
    private static final int METRICS_EXPORT_INTERVAL = 30;
    static final String DEFAULT_METRIC_CUSTOM_TAG_KEY = "opencensus_task";
    @VisibleForTesting
    static final ImmutableSet<String> SERVICES_TO_EXCLUDE = ImmutableSet.of((Object)"google.logging.v2.LoggingServiceV2", (Object)"google.monitoring.v3.MetricService", (Object)"google.devtools.cloudtrace.v2.TraceService");
    private static GcpObservability instance = null;
    private final Sink sink;
    private final ObservabilityConfig config;
    private final ArrayList<ClientInterceptor> clientInterceptors = new ArrayList();
    private final ArrayList<ServerInterceptor> serverInterceptors = new ArrayList();
    private final ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList();

    public static synchronized GcpObservability grpcInit() throws IOException {
        if (instance == null) {
            ObservabilityConfigImpl observabilityConfig = ObservabilityConfigImpl.getInstance();
            TraceLoggingHelper traceLoggingHelper = new TraceLoggingHelper(observabilityConfig.getProjectId());
            GcpLogSink sink = new GcpLogSink(observabilityConfig.getProjectId(), observabilityConfig, (Collection<String>)SERVICES_TO_EXCLUDE, traceLoggingHelper);
            LogHelper helper = new LogHelper(sink);
            ConfigFilterHelper configFilterHelper = ConfigFilterHelper.getInstance(observabilityConfig);
            instance = GcpObservability.grpcInit(sink, observabilityConfig, new InternalLoggingChannelInterceptor.FactoryImpl(helper, configFilterHelper), new InternalLoggingServerInterceptor.FactoryImpl(helper, configFilterHelper));
            instance.registerStackDriverExporter(observabilityConfig.getProjectId(), observabilityConfig.getCustomTags());
        }
        return instance;
    }

    @VisibleForTesting
    static GcpObservability grpcInit(Sink sink, ObservabilityConfig config, InternalLoggingChannelInterceptor.Factory channelInterceptorFactory, InternalLoggingServerInterceptor.Factory serverInterceptorFactory) throws IOException {
        if (instance == null) {
            instance = new GcpObservability(sink, config);
            instance.setProducer(channelInterceptorFactory, serverInterceptorFactory);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<GcpObservability> clazz = GcpObservability.class;
        synchronized (GcpObservability.class) {
            if (instance == null) {
                throw new IllegalStateException("GcpObservability already closed!");
            }
            this.sink.close();
            if (this.config.isEnableCloudMonitoring() || this.config.isEnableCloudTracing()) {
                try {
                    Thread.sleep(TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.log(Level.SEVERE, "Caught exception during sleep", e);
                }
            }
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setProducer(InternalLoggingChannelInterceptor.Factory channelInterceptorFactory, InternalLoggingServerInterceptor.Factory serverInterceptorFactory) {
        if (this.config.isEnableCloudLogging()) {
            this.clientInterceptors.add(channelInterceptorFactory.create());
            this.serverInterceptors.add(serverInterceptorFactory.create());
        }
        if (this.config.isEnableCloudMonitoring()) {
            this.clientInterceptors.add(GcpObservability.getConditionalInterceptor(InternalCensusStatsAccessor.getClientInterceptor((boolean)true, (boolean)true, (boolean)false, (boolean)true)));
            this.tracerFactories.add(InternalCensusStatsAccessor.getServerStreamTracerFactory((boolean)true, (boolean)true, (boolean)false));
        }
        if (this.config.isEnableCloudTracing()) {
            this.clientInterceptors.add(GcpObservability.getConditionalInterceptor(InternalCensusTracingAccessor.getClientInterceptor()));
            this.tracerFactories.add(InternalCensusTracingAccessor.getServerStreamTracerFactory());
        }
        InternalGlobalInterceptors.setInterceptorsTracers(this.clientInterceptors, this.serverInterceptors, this.tracerFactories);
    }

    static ConditionalClientInterceptor getConditionalInterceptor(ClientInterceptor interceptor) {
        return new ConditionalClientInterceptor(interceptor, (m, c) -> !SERVICES_TO_EXCLUDE.contains((Object)m.getServiceName()));
    }

    private static void registerObservabilityViews() {
        ViewManager viewManager = Stats.getViewManager();
        viewManager.registerView(RpcViewConstants.GRPC_CLIENT_COMPLETED_RPC_VIEW);
        viewManager.registerView(RpcViewConstants.GRPC_CLIENT_STARTED_RPC_VIEW);
        viewManager.registerView(RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW);
        viewManager.registerView(ObservabilityCensusConstants.GRPC_CLIENT_API_LATENCY_VIEW);
        viewManager.registerView(ObservabilityCensusConstants.GRPC_CLIENT_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW);
        viewManager.registerView(ObservabilityCensusConstants.GRPC_CLIENT_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW);
        viewManager.registerView(RpcViewConstants.GRPC_SERVER_COMPLETED_RPC_VIEW);
        viewManager.registerView(RpcViewConstants.GRPC_SERVER_STARTED_RPC_VIEW);
        viewManager.registerView(RpcViewConstants.GRPC_SERVER_SERVER_LATENCY_VIEW);
        viewManager.registerView(ObservabilityCensusConstants.GRPC_SERVER_SENT_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW);
        viewManager.registerView(ObservabilityCensusConstants.GRPC_SERVER_RECEIVED_COMPRESSED_MESSAGE_BYTES_PER_RPC_VIEW);
    }

    @VisibleForTesting
    void registerStackDriverExporter(String projectId, Map<String, String> customTags) throws IOException {
        if (this.config.isEnableCloudMonitoring()) {
            GcpObservability.registerObservabilityViews();
            StackdriverStatsConfiguration.Builder statsConfigurationBuilder = StackdriverStatsConfiguration.builder();
            if (projectId != null) {
                statsConfigurationBuilder.setProjectId(projectId);
            }
            HashMap<LabelKey, LabelValue> constantLabels = new HashMap<LabelKey, LabelValue>();
            constantLabels.put(LabelKey.create((String)DEFAULT_METRIC_CUSTOM_TAG_KEY, (String)DEFAULT_METRIC_CUSTOM_TAG_KEY), LabelValue.create((String)GcpObservability.generateDefaultMetricTagValue()));
            if (customTags != null) {
                for (Map.Entry<String, String> mapEntry : customTags.entrySet()) {
                    constantLabels.putIfAbsent(LabelKey.create((String)mapEntry.getKey(), (String)mapEntry.getKey()), LabelValue.create((String)mapEntry.getValue()));
                }
            }
            statsConfigurationBuilder.setConstantLabels(constantLabels);
            statsConfigurationBuilder.setExportInterval(Duration.create((long)30L, (int)0));
            StackdriverStatsExporter.createAndRegister((StackdriverStatsConfiguration)statsConfigurationBuilder.build());
        }
        if (this.config.isEnableCloudTracing()) {
            TraceConfig traceConfig = Tracing.getTraceConfig();
            traceConfig.updateActiveTraceParams(traceConfig.getActiveTraceParams().toBuilder().setSampler(this.config.getSampler()).build());
            StackdriverTraceConfiguration.Builder traceConfigurationBuilder = StackdriverTraceConfiguration.builder();
            if (projectId != null) {
                traceConfigurationBuilder.setProjectId(projectId);
            }
            if (customTags != null) {
                Map<String, AttributeValue> fixedAttributes = customTags.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> AttributeValue.stringAttributeValue((String)((String)e.getValue()))));
                traceConfigurationBuilder.setFixedAttributes(fixedAttributes);
            }
            StackdriverTraceExporter.createAndRegister((StackdriverTraceConfiguration)traceConfigurationBuilder.build());
        }
    }

    private static String generateDefaultMetricTagValue() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + new SecureRandom().nextInt() + "@" + hostname;
        }
        return "java-" + jvmName;
    }

    private GcpObservability(Sink sink, ObservabilityConfig config) {
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink);
        this.config = (ObservabilityConfig)Preconditions.checkNotNull((Object)config);
    }
}

