/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.routeguide;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.examples.routeguide.Feature;
import io.grpc.examples.routeguide.Point;
import io.grpc.examples.routeguide.Rectangle;
import io.grpc.examples.routeguide.RouteGuideGrpc;
import io.grpc.examples.routeguide.RouteGuideUtil;
import io.grpc.examples.routeguide.RouteNote;
import io.grpc.examples.routeguide.RouteSummary;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RouteGuideClient {
    private static final Logger logger = Logger.getLogger(RouteGuideClient.class.getName());
    private final ManagedChannel channel;
    private final RouteGuideGrpc.RouteGuideBlockingStub blockingStub;
    private final RouteGuideGrpc.RouteGuideStub asyncStub;

    public RouteGuideClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true));
    }

    public RouteGuideClient(ManagedChannelBuilder<?> channelBuilder) {
        this.channel = channelBuilder.build();
        this.blockingStub = RouteGuideGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RouteGuideGrpc.newStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void getFeature(int lat, int lon) {
        Feature feature;
        RouteGuideClient.info("*** GetFeature: lat={0} lon={1}", lat, lon);
        Point request = Point.newBuilder().setLatitude(lat).setLongitude(lon).build();
        try {
            feature = this.blockingStub.getFeature(request);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
        if (RouteGuideUtil.exists(feature)) {
            RouteGuideClient.info("Found feature called \"{0}\" at {1}, {2}", feature.getName(), RouteGuideUtil.getLatitude(feature.getLocation()), RouteGuideUtil.getLongitude(feature.getLocation()));
        } else {
            RouteGuideClient.info("Found no feature at {0}, {1}", RouteGuideUtil.getLatitude(feature.getLocation()), RouteGuideUtil.getLongitude(feature.getLocation()));
        }
    }

    public void listFeatures(int lowLat, int lowLon, int hiLat, int hiLon) {
        Iterator<Feature> features;
        RouteGuideClient.info("*** ListFeatures: lowLat={0} lowLon={1} hiLat={2} hiLon={3}", lowLat, lowLon, hiLat, hiLon);
        Rectangle request = Rectangle.newBuilder().setLo(Point.newBuilder().setLatitude(lowLat).setLongitude(lowLon).build()).setHi(Point.newBuilder().setLatitude(hiLat).setLongitude(hiLon).build()).build();
        try {
            features = this.blockingStub.listFeatures(request);
        }
        catch (StatusRuntimeException e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e.getStatus());
            return;
        }
        StringBuilder responseLog = new StringBuilder("Result: ");
        while (features.hasNext()) {
            Feature feature = features.next();
            responseLog.append(feature);
        }
        RouteGuideClient.info(responseLog.toString(), new Object[0]);
    }

    public void recordRoute(List<Feature> features, int numPoints) throws InterruptedException {
        RouteGuideClient.info("*** RecordRoute", new Object[0]);
        final CountDownLatch finishLatch = new CountDownLatch(1);
        StreamObserver<RouteSummary> responseObserver = new StreamObserver<RouteSummary>(){

            public void onNext(RouteSummary summary) {
                RouteGuideClient.info("Finished trip with {0} points. Passed {1} features. Travelled {2} meters. It took {3} seconds.", new Object[]{summary.getPointCount(), summary.getFeatureCount(), summary.getDistance(), summary.getElapsedTime()});
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                logger.log(Level.WARNING, "RecordRoute Failed: {0}", status);
                finishLatch.countDown();
            }

            public void onCompleted() {
                RouteGuideClient.info("Finished RecordRoute", new Object[0]);
                finishLatch.countDown();
            }
        };
        StreamObserver<Point> requestObserver = this.asyncStub.recordRoute(responseObserver);
        try {
            Random rand = new Random();
            for (int i = 0; i < numPoints; ++i) {
                int index = rand.nextInt(features.size());
                Point point = features.get(index).getLocation();
                RouteGuideClient.info("Visiting point {0}, {1}", RouteGuideUtil.getLatitude(point), RouteGuideUtil.getLongitude(point));
                requestObserver.onNext((Object)point);
                Thread.sleep(rand.nextInt(1000) + 500);
                if (finishLatch.getCount() != 0L) continue;
                return;
            }
        }
        catch (RuntimeException e) {
            requestObserver.onError((Throwable)e);
            throw e;
        }
        requestObserver.onCompleted();
        finishLatch.await(1L, TimeUnit.MINUTES);
    }

    public void routeChat() throws InterruptedException {
        RouteGuideClient.info("*** RoutChat", new Object[0]);
        final CountDownLatch finishLatch = new CountDownLatch(1);
        StreamObserver<RouteNote> requestObserver = this.asyncStub.routeChat(new StreamObserver<RouteNote>(){

            public void onNext(RouteNote note) {
                RouteGuideClient.info("Got message \"{0}\" at {1}, {2}", new Object[]{note.getMessage(), note.getLocation().getLatitude(), note.getLocation().getLongitude()});
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                logger.log(Level.WARNING, "RouteChat Failed: {0}", status);
                finishLatch.countDown();
            }

            public void onCompleted() {
                RouteGuideClient.info("Finished RouteChat", new Object[0]);
                finishLatch.countDown();
            }
        });
        try {
            RouteNote[] requests;
            for (RouteNote request : requests = new RouteNote[]{this.newNote("First message", 0, 0), this.newNote("Second message", 0, 1), this.newNote("Third message", 1, 0), this.newNote("Fourth message", 1, 1)}) {
                RouteGuideClient.info("Sending message \"{0}\" at {1}, {2}", request.getMessage(), request.getLocation().getLatitude(), request.getLocation().getLongitude());
                requestObserver.onNext((Object)request);
            }
        }
        catch (RuntimeException e) {
            requestObserver.onError((Throwable)e);
            throw e;
        }
        requestObserver.onCompleted();
        finishLatch.await(1L, TimeUnit.MINUTES);
    }

    public static void main(String[] args) throws InterruptedException {
        List<Feature> features;
        try {
            features = RouteGuideUtil.parseFeatures(RouteGuideUtil.getDefaultFeaturesFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        RouteGuideClient client = new RouteGuideClient("localhost", 8980);
        try {
            client.getFeature(409146138, -746188906);
            client.getFeature(0, 0);
            client.listFeatures(400000000, -750000000, 420000000, -730000000);
            client.recordRoute(features, 10);
            client.routeChat();
        }
        finally {
            client.shutdown();
        }
    }

    private static void info(String msg, Object ... params) {
        logger.log(Level.INFO, msg, params);
    }

    private RouteNote newNote(String message, int lat, int lon) {
        return RouteNote.newBuilder().setMessage(message).setLocation(Point.newBuilder().setLatitude(lat).setLongitude(lon).build()).build();
    }
}

