/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.header;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.examples.header.HeaderServerInterceptor;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.logging.Logger;

public class CustomHeaderServer {
    private static final Logger logger = Logger.getLogger(CustomHeaderServer.class.getName());
    private static final int port = 50051;
    private Server server;

    private void start() throws IOException {
        this.server = ServerBuilder.forPort((int)50051).addService(ServerInterceptors.intercept((BindableService)new GreeterImpl(), (ServerInterceptor[])new ServerInterceptor[]{new HeaderServerInterceptor()})).build().start();
        logger.info("Server started, listening on 50051");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                CustomHeaderServer.this.stop();
                System.err.println("*** server shut down");
            }
        });
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        CustomHeaderServer server = new CustomHeaderServer();
        server.start();
        server.blockUntilShutdown();
    }

    private static class GreeterImpl
    extends GreeterGrpc.GreeterImplBase {
        private GreeterImpl() {
        }

        @Override
        public void sayHello(HelloRequest req, StreamObserver<HelloReply> responseObserver) {
            HelloReply reply = HelloReply.newBuilder().setMessage("Hello " + req.getName()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }
}

