/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.override;

import io.grpc.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OpenTelemetryContextStorage
extends Context.Storage {
    private static final Logger logger = Logger.getLogger(OpenTelemetryContextStorage.class.getName());
    private static final Context.Key<io.opentelemetry.context.Context> OTEL_CONTEXT_OVER_GRPC = Context.key((String)"otel-context-over-grpc");
    private static final Context.Key<Scope> OTEL_SCOPE = Context.key((String)"otel-scope");
    private static final ContextKey<Context> GRPC_CONTEXT_OVER_OTEL = ContextKey.named((String)"grpc-context-over-otel");

    OpenTelemetryContextStorage() {
    }

    public Context doAttach(Context toAttach) {
        Context previous = this.current();
        io.opentelemetry.context.Context otelContext = (io.opentelemetry.context.Context)OTEL_CONTEXT_OVER_GRPC.get(toAttach);
        if (otelContext == null) {
            otelContext = io.opentelemetry.context.Context.current();
        }
        Scope scope = otelContext.with(GRPC_CONTEXT_OVER_OTEL, (Object)toAttach).makeCurrent();
        return previous.withValue(OTEL_SCOPE, (Object)scope);
    }

    public void detach(Context toDetach, Context toRestore) {
        Scope scope = (Scope)OTEL_SCOPE.get(toRestore);
        if (scope == null) {
            logger.log(Level.SEVERE, "Detaching context which was not attached.");
        } else {
            scope.close();
        }
    }

    public Context current() {
        io.opentelemetry.context.Context otelCurrent = io.opentelemetry.context.Context.current();
        Context grpcCurrent = (Context)otelCurrent.get(GRPC_CONTEXT_OVER_OTEL);
        if (grpcCurrent == null) {
            grpcCurrent = Context.ROOT;
        }
        return grpcCurrent.withValue(OTEL_CONTEXT_OVER_GRPC, (Object)otelCurrent);
    }
}

