/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.driver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.benchmarks.driver.LoadClient;
import io.grpc.benchmarks.driver.LoadServer;
import io.grpc.benchmarks.proto.Control;
import io.grpc.benchmarks.proto.WorkerServiceGrpc;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadWorker {
    private static final Logger log = Logger.getLogger(LoadWorker.class.getName());
    private final int serverPort;
    private final Server driverServer;

    LoadWorker(int driverPort, int serverPort) throws Exception {
        this.serverPort = serverPort;
        NioEventLoopGroup singleThreadGroup = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("load-worker-%d").build());
        this.driverServer = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)driverPort, (ServerCredentials)InsecureServerCredentials.create()).directExecutor()).channelType(NioServerSocketChannel.class).workerEventLoopGroup((EventLoopGroup)singleThreadGroup).bossEventLoopGroup((EventLoopGroup)singleThreadGroup).addService((BindableService)new WorkerServiceImpl())).build();
    }

    public void start() throws Exception {
        this.driverServer.start();
    }

    public static void main(String[] args) throws Exception {
        boolean usage = false;
        int serverPort = 0;
        int driverPort = 0;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_port".equals(key)) {
                serverPort = Integer.valueOf(value);
                continue;
            }
            if ("driver_port".equals(key)) {
                driverPort = Integer.valueOf(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage || driverPort == 0) {
            System.err.println("Usage: [ARGS...]\n\n  --driver_port=<port>\n    Port to expose grpc.testing.WorkerService, used by driver to initiate work.\n  --server_port=<port>\n    Port to start load servers on, if not specified by the server config\n    message. Defaults to any available port.");
            System.exit(1);
        }
        LoadWorker loadWorker = new LoadWorker(driverPort, serverPort);
        loadWorker.start();
        loadWorker.driverServer.awaitTermination();
        log.log(Level.INFO, "DriverServer has terminated.");
        Thread.sleep(3000L);
    }

    private class WorkerServiceImpl
    extends WorkerServiceGrpc.WorkerServiceImplBase {
        private LoadServer workerServer;
        private LoadClient workerClient;

        private WorkerServiceImpl() {
        }

        @Override
        public StreamObserver<Control.ServerArgs> runServer(final StreamObserver<Control.ServerStatus> responseObserver) {
            return new StreamObserver<Control.ServerArgs>(){

                public void onNext(Control.ServerArgs value) {
                    try {
                        Control.ServerArgs.ArgtypeCase argTypeCase = value.getArgtypeCase();
                        if (argTypeCase == Control.ServerArgs.ArgtypeCase.SETUP && WorkerServiceImpl.this.workerServer == null) {
                            if (LoadWorker.this.serverPort != 0 && value.getSetup().getPort() == 0) {
                                Control.ServerArgs.Builder builder = value.toBuilder();
                                builder.getSetupBuilder().setPort(LoadWorker.this.serverPort);
                                value = builder.build();
                            }
                            WorkerServiceImpl.this.workerServer = new LoadServer(value.getSetup());
                            WorkerServiceImpl.this.workerServer.start();
                            responseObserver.onNext((Object)Control.ServerStatus.newBuilder().setPort(WorkerServiceImpl.this.workerServer.getPort()).setCores(WorkerServiceImpl.this.workerServer.getCores()).build());
                        } else if (argTypeCase == Control.ServerArgs.ArgtypeCase.MARK && WorkerServiceImpl.this.workerServer != null) {
                            responseObserver.onNext((Object)Control.ServerStatus.newBuilder().setStats(WorkerServiceImpl.this.workerServer.getStats()).build());
                        } else {
                            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription("Server already started").asRuntimeException());
                        }
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Error running server", t);
                        responseObserver.onError((Throwable)Status.INTERNAL.withCause(t).asException());
                        this.onCompleted();
                    }
                }

                public void onError(Throwable t) {
                    Status status = Status.fromThrowable((Throwable)t);
                    if (status.getCode() != Status.Code.CANCELLED) {
                        log.log(Level.WARNING, "Error driving server", t);
                    }
                    this.onCompleted();
                }

                public void onCompleted() {
                    try {
                        if (WorkerServiceImpl.this.workerServer != null) {
                            WorkerServiceImpl.this.workerServer.shutdownNow();
                        }
                    }
                    finally {
                        WorkerServiceImpl.this.workerServer = null;
                        responseObserver.onCompleted();
                    }
                }
            };
        }

        @Override
        public StreamObserver<Control.ClientArgs> runClient(final StreamObserver<Control.ClientStatus> responseObserver) {
            return new StreamObserver<Control.ClientArgs>(){

                public void onNext(Control.ClientArgs value) {
                    try {
                        Control.ClientArgs.ArgtypeCase argTypeCase = value.getArgtypeCase();
                        if (argTypeCase == Control.ClientArgs.ArgtypeCase.SETUP && WorkerServiceImpl.this.workerClient == null) {
                            WorkerServiceImpl.this.workerClient = new LoadClient(value.getSetup());
                            WorkerServiceImpl.this.workerClient.start();
                            responseObserver.onNext((Object)Control.ClientStatus.newBuilder().build());
                        } else if (argTypeCase == Control.ClientArgs.ArgtypeCase.MARK && WorkerServiceImpl.this.workerClient != null) {
                            responseObserver.onNext((Object)Control.ClientStatus.newBuilder().setStats(WorkerServiceImpl.this.workerClient.getStats()).build());
                        } else {
                            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription("Client already started").asRuntimeException());
                        }
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Error running client", t);
                        responseObserver.onError((Throwable)Status.INTERNAL.withCause(t).asException());
                        this.onCompleted();
                    }
                }

                public void onError(Throwable t) {
                    Status status = Status.fromThrowable((Throwable)t);
                    if (status.getCode() != Status.Code.CANCELLED) {
                        log.log(Level.WARNING, "Error driving client", t);
                    }
                    this.onCompleted();
                }

                public void onCompleted() {
                    try {
                        if (WorkerServiceImpl.this.workerClient != null) {
                            WorkerServiceImpl.this.workerClient.shutdownNow();
                        }
                    }
                    finally {
                        WorkerServiceImpl.this.workerClient = null;
                        responseObserver.onCompleted();
                    }
                }
            };
        }

        @Override
        public void coreCount(Control.CoreRequest request, StreamObserver<Control.CoreResponse> responseObserver) {
            responseObserver.onNext((Object)Control.CoreResponse.newBuilder().setCores(Runtime.getRuntime().availableProcessors()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void quitWorker(Control.Void request, StreamObserver<Control.Void> responseObserver) {
            try {
                log.log(Level.INFO, "Received quitWorker request.");
                responseObserver.onNext((Object)Control.Void.getDefaultInstance());
                responseObserver.onCompleted();
                LoadWorker.this.driverServer.shutdown();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Error during shutdown", t);
            }
        }
    }
}

