/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.benchmarks.Transport;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.NegotiationType;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.testing.TestUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import org.HdrHistogram.Histogram;

public final class Utils {
    private static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";
    public static final long HISTOGRAM_MAX_VALUE = 60000000L;
    public static final int HISTOGRAM_PRECISION = 3;
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;

    private Utils() {
    }

    public static boolean parseBoolean(String value) {
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    public static SocketAddress parseSocketAddress(String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            File file = new File(filePath);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("File path must be absolute: " + filePath);
            }
            try {
                if (file.createNewFile()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new DomainSocketAddress(file);
        }
        String[] parts = value.split(":", 2);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Address must be a unix:// path or be in the form host:port. Got: " + value);
        }
        String host = parts[0];
        int port = Integer.parseInt(parts[1]);
        return new InetSocketAddress(host, port);
    }

    public static ManagedChannel newClientChannel(Transport transport, SocketAddress address, boolean tls, boolean testca, @Nullable String authorityOverride, boolean useDefaultCiphers, int flowControlWindow, boolean directExecutor) throws IOException {
        Class<NioSocketChannel> channelType;
        NioEventLoopGroup group;
        io.grpc.netty.NegotiationType negotiationType;
        if (transport == Transport.OK_HTTP) {
            InetSocketAddress addr = (InetSocketAddress)address;
            OkHttpChannelBuilder builder = OkHttpChannelBuilder.forAddress((String)addr.getHostName(), (int)addr.getPort());
            if (directExecutor) {
                builder.directExecutor();
            }
            builder.negotiationType(tls ? NegotiationType.TLS : NegotiationType.PLAINTEXT);
            if (tls) {
                SSLSocketFactory factory;
                if (testca) {
                    builder.overrideAuthority(GrpcUtil.authorityFromHostAndPort((String)authorityOverride, (int)addr.getPort()));
                    try {
                        factory = TestUtils.newSslSocketFactoryForCa((File)TestUtils.loadCert((String)"ca.pem"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                builder.sslSocketFactory(factory);
            }
            if (authorityOverride != null) {
                builder.overrideAuthority(authorityOverride);
            }
            return builder.build();
        }
        SslContext sslContext = null;
        io.grpc.netty.NegotiationType negotiationType2 = negotiationType = tls ? io.grpc.netty.NegotiationType.TLS : io.grpc.netty.NegotiationType.PLAINTEXT;
        if (tls && testca) {
            File cert = TestUtils.loadCert((String)"ca.pem");
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().trustManager(cert);
            sslContextBuilder = transport == Transport.NETTY_NIO ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.JDK) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            if (useDefaultCiphers) {
                sslContextBuilder.ciphers(null);
            }
            sslContext = sslContextBuilder.build();
        }
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ELG-%d").build();
        switch (transport) {
            case NETTY_NIO: {
                group = new NioEventLoopGroup(0, tf);
                channelType = NioSocketChannel.class;
                break;
            }
            case NETTY_EPOLL: {
                group = new EpollEventLoopGroup(0, tf);
                channelType = EpollSocketChannel.class;
                break;
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                group = new EpollEventLoopGroup(0, tf);
                channelType = EpollDomainSocketChannel.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)transport));
            }
        }
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((SocketAddress)address).eventLoopGroup((EventLoopGroup)group).channelType(channelType).negotiationType(negotiationType).sslContext(sslContext).flowControlWindow(flowControlWindow);
        if (authorityOverride != null) {
            builder.overrideAuthority(authorityOverride);
        }
        if (directExecutor) {
            builder.directExecutor();
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHistogram(Histogram histogram, String filename) throws IOException {
        PrintStream log = null;
        try {
            File file = new File(filename);
            if (file.exists() && !file.delete()) {
                System.err.println("Failed deleting previous histogram file: " + file.getAbsolutePath());
            }
            log = new PrintStream(new FileOutputStream(file), false);
            histogram.outputPercentileDistribution(log, Double.valueOf(1.0));
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }

    public static Messages.SimpleResponse makeResponse(Messages.SimpleRequest request) {
        if (request.getResponseSize() > 0) {
            if (!Messages.PayloadType.COMPRESSABLE.equals((Object)request.getResponseType())) {
                throw Status.INTERNAL.augmentDescription("Error creating payload.").asRuntimeException();
            }
            ByteString body = ByteString.copyFrom((byte[])new byte[request.getResponseSize()]);
            Messages.PayloadType type = request.getResponseType();
            Messages.Payload payload = Messages.Payload.newBuilder().setType(type).setBody(body).build();
            return Messages.SimpleResponse.newBuilder().setPayload(payload).build();
        }
        return Messages.SimpleResponse.getDefaultInstance();
    }

    public static Messages.SimpleRequest makeRequest(Messages.PayloadType payloadType, int reqLength, int respLength) {
        ByteString body = ByteString.copyFrom((byte[])new byte[reqLength]);
        Messages.Payload payload = Messages.Payload.newBuilder().setType(payloadType).setBody(body).build();
        return Messages.SimpleRequest.newBuilder().setResponseType(payloadType).setResponseSize(respLength).setPayload(payload).build();
    }

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

