/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.server.tcp;

import io.gravitee.node.vertx.server.VertxServerOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.TCPSSLOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxTcpServerOptions
extends VertxServerOptions {
    private static final Logger log = LoggerFactory.getLogger(VertxTcpServerOptions.class);
    public static final String TCP_PREFIX = "tcp";

    public NetServerOptions createNetServerOptions() {
        NetServerOptions options = new NetServerOptions();
        options.setPort(this.port);
        options.setHost(this.host);
        if (!this.secured || !this.sni) {
            throw new IllegalArgumentException("Cannot start unsecured TCP server or without SNI enabled");
        }
        options.setSni(true);
        options.setClientAuth(ClientAuth.valueOf((String)this.clientAuth));
        this.setupTcp((TCPSSLOptions)options);
        if (this.haProxyProtocol) {
            options.setUseProxyProtocol(true).setProxyProtocolTimeout(this.haProxyProtocolTimeout);
        }
        return options;
    }

    protected VertxTcpServerOptions(VertxTcpServerOptionsBuilder<?, ?> b) {
        super(b);
    }

    public static VertxTcpServerOptionsBuilder<?, ?> builder() {
        return new VertxTcpServerOptionsBuilderImpl();
    }

    private static final class VertxTcpServerOptionsBuilderImpl
    extends VertxTcpServerOptionsBuilder<VertxTcpServerOptions, VertxTcpServerOptionsBuilderImpl> {
        private VertxTcpServerOptionsBuilderImpl() {
        }

        @Override
        protected VertxTcpServerOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public VertxTcpServerOptions build() {
            return new VertxTcpServerOptions(this);
        }
    }

    public static abstract class VertxTcpServerOptionsBuilder<C extends VertxTcpServerOptions, B extends VertxTcpServerOptionsBuilder<C, B>>
    extends VertxServerOptions.VertxServerOptionsBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VertxTcpServerOptions.VertxTcpServerOptionsBuilder(super=" + super.toString() + ")";
        }
    }
}

