/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx;

import io.gravitee.node.api.Node;
import io.gravitee.node.tracing.vertx.LazyVertxTracerFactory;
import io.gravitee.node.vertx.metrics.ExcludeTagsFilter;
import io.gravitee.node.vertx.metrics.RenameVertxFilter;
import io.gravitee.node.vertx.verticle.factory.SpringVerticleFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class VertxFactory
implements FactoryBean<Vertx> {
    private static final String PROMETHEUS_LABEL_VERSION_3_10 = "3.10";
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxFactory.class);
    @Autowired
    private Node node;
    @Autowired
    private Environment environment;
    @Autowired
    private SpringVerticleFactory springVerticleFactory;
    @Autowired
    private LazyVertxTracerFactory vertxTracerFactory;
    private Set<Label> metricsLabels;
    private Map<String, Set<Label>> metricsExcludedLabelsByCategory;

    public Vertx getObject() throws Exception {
        boolean tracingEnabled;
        LOGGER.debug("Creating a new instance of Vert.x");
        VertxOptions options = this.getVertxOptions();
        boolean metricsEnabled = (Boolean)this.environment.getProperty("services.metrics.enabled", Boolean.class, (Object)false);
        if (metricsEnabled) {
            this.configureMetrics(options);
        }
        if (tracingEnabled = ((Boolean)this.environment.getProperty("services.tracing.enabled", Boolean.class, (Object)false)).booleanValue()) {
            this.configureTracing(options);
        }
        Vertx instance = Vertx.vertx((VertxOptions)options);
        instance.registerVerticleFactory((VerticleFactory)this.springVerticleFactory);
        if (metricsEnabled) {
            MeterRegistry registry = BackendRegistries.getDefaultNow();
            registry.config().meterFilter((MeterFilter)new RenameVertxFilter()).commonTags(new String[]{"application", this.node.application()}).commonTags(new String[]{"instance", this.node.hostname()});
            this.metricsExcludedLabelsByCategory.forEach((category, labels) -> registry.config().meterFilter((MeterFilter)new ExcludeTagsFilter((String)category, labels.stream().map(String::valueOf).collect(Collectors.toList()))));
            new FileDescriptorMetrics().bindTo(registry);
            new ClassLoaderMetrics().bindTo(registry);
            new JvmMemoryMetrics().bindTo(registry);
            new JvmGcMetrics().bindTo(registry);
            new ProcessorMetrics().bindTo(registry);
            new JvmThreadMetrics().bindTo(registry);
        }
        return instance;
    }

    private void configureMetrics(VertxOptions options) {
        LOGGER.info("Metrics support is enabled");
        MicrometerMetricsOptions micrometerMetricsOptions = new MicrometerMetricsOptions();
        micrometerMetricsOptions.setDisabledMetricsCategories(new HashSet<String>(Arrays.asList(MetricsDomain.DATAGRAM_SOCKET.toCategory(), MetricsDomain.NAMED_POOLS.toCategory(), MetricsDomain.VERTICLES.toCategory(), MetricsDomain.EVENT_BUS.toCategory()))).setEnabled(true);
        String namesVersion = this.environment.getProperty("services.metrics.prometheus.naming.version");
        if (PROMETHEUS_LABEL_VERSION_3_10.equals(namesVersion)) {
            micrometerMetricsOptions.setMetricsNaming(MetricsNaming.v3Names());
        }
        this.loadMetricLabels();
        micrometerMetricsOptions.setLabels(this.metricsLabels);
        boolean prometheusEnabled = (Boolean)this.environment.getProperty("services.metrics.prometheus.enabled", Boolean.class, (Object)true);
        if (prometheusEnabled) {
            LOGGER.info("Prometheus metrics support is enabled");
            micrometerMetricsOptions.setPrometheusOptions(new VertxPrometheusOptions().setEnabled(true));
        }
        options.setMetricsOptions((MetricsOptions)micrometerMetricsOptions);
    }

    private void configureTracing(VertxOptions options) {
        options.setTracingOptions(new TracingOptions().setFactory((VertxTracerFactory)this.vertxTracerFactory));
    }

    public Class<?> getObjectType() {
        return Vertx.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void loadMetricLabels() {
        Map<String, Set<Label>> includedLabelsByCategory = this.readConfiguredLabelsByCategory("include");
        Set<String> labels = this.readConfiguredLabels();
        this.metricsLabels = labels != null && !labels.isEmpty() ? labels.stream().map(this::toLabel).collect(Collectors.toSet()) : EnumSet.of(Label.LOCAL, Label.HTTP_METHOD, Label.HTTP_CODE);
        includedLabelsByCategory.forEach((category, includedLabels) -> this.metricsLabels.addAll((Collection<Label>)includedLabels));
        this.metricsExcludedLabelsByCategory = this.readConfiguredLabelsByCategory("exclude");
        for (Map.Entry<String, Set<Label>> labelsByCategory : includedLabelsByCategory.entrySet()) {
            String includedCategory = labelsByCategory.getKey();
            Set<Label> includedCategoryLabels = labelsByCategory.getValue();
            Arrays.stream(MetricsDomain.values()).map(MetricsDomain::toCategory).filter(otherCategory -> !otherCategory.equalsIgnoreCase(includedCategory)).forEach(otherCategory -> {
                if (includedLabelsByCategory.containsKey(otherCategory)) {
                    Set otherCategoryLabels = (Set)includedLabelsByCategory.get(otherCategory);
                    includedCategoryLabels.forEach(label -> {
                        if (!otherCategoryLabels.contains(label)) {
                            this.metricsExcludedLabelsByCategory.computeIfAbsent((String)otherCategory, key -> new HashSet()).add(label);
                        }
                    });
                } else {
                    includedCategoryLabels.forEach(label -> this.metricsExcludedLabelsByCategory.computeIfAbsent((String)otherCategory, key -> new HashSet()).add(label));
                }
            });
        }
    }

    private Map<String, Set<Label>> readConfiguredLabelsByCategory(String type) {
        HashMap<String, Set<Label>> labelsByCategory = new HashMap<String, Set<Label>>();
        for (MetricsDomain metricsDomain : MetricsDomain.values()) {
            String value;
            String category = metricsDomain.toCategory();
            HashSet<Label> labels = new HashSet<Label>();
            int counter = 0;
            labelsByCategory.put(category, labels);
            while ((value = this.environment.getProperty("services.metrics." + type + "." + category + "[" + counter++ + "]")) != null) {
                labels.add(this.toLabel(value));
            }
        }
        return labelsByCategory;
    }

    private Label toLabel(String label) {
        return Label.valueOf((String)label.toUpperCase());
    }

    private Set<String> readConfiguredLabels() {
        LOGGER.debug("Looking for metrics labels...");
        HashSet<String> labels = null;
        boolean found = true;
        int idx = 0;
        while (found) {
            String label = this.environment.getProperty("services.metrics.labels[" + idx + "]");
            boolean bl = found = label != null;
            if (found) {
                if (labels == null) {
                    labels = new HashSet<String>();
                }
                labels.add(label);
            }
            ++idx;
        }
        return labels;
    }

    private VertxOptions getVertxOptions() {
        Long warningExceptionTime;
        Long maxEventLoopExecuteTime;
        VertxOptions options = new VertxOptions();
        options.setPreferNativeTransport(true);
        Long blockedThreadCheckInterval = Long.getLong("vertx.options.blockedThreadCheckInterval");
        if (blockedThreadCheckInterval != null) {
            options.setBlockedThreadCheckInterval(blockedThreadCheckInterval.longValue());
        }
        if ((maxEventLoopExecuteTime = Long.getLong("vertx.options.maxEventLoopExecuteTime")) != null) {
            options.setMaxEventLoopExecuteTime(maxEventLoopExecuteTime.longValue());
        }
        if ((warningExceptionTime = Long.getLong("vertx.options.warningExceptionTime")) != null) {
            options.setWarningExceptionTime(warningExceptionTime.longValue());
        }
        return options;
    }
}

