/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.service.keystoreloader;

import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderFactory;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.secrets.service.conf.GraviteeConfigurationSecretResolverDispatcher;
import io.gravitee.node.secrets.service.keystoreloader.SecretProviderKeyStoreLoader;
import java.util.Arrays;
import java.util.List;

public class SecretProviderKeyStoreLoaderFactory
implements KeyStoreLoaderFactory {
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("PEM", "PKCS12", "JKS");
    final GraviteeConfigurationSecretResolverDispatcher secretResolverDispatcher;

    public boolean canHandle(KeyStoreLoaderOptions options) {
        String secretLocation = options.getSecretLocation();
        return secretLocation != null && options.getKeyStoreType() != null && SUPPORTED_TYPES.contains(options.getKeyStoreType().toUpperCase()) && this.secretResolverDispatcher.canHandle(secretLocation);
    }

    public KeyStoreLoader create(KeyStoreLoaderOptions options) {
        return new SecretProviderKeyStoreLoader(this.secretResolverDispatcher, options);
    }

    public SecretProviderKeyStoreLoaderFactory(GraviteeConfigurationSecretResolverDispatcher secretResolverDispatcher) {
        this.secretResolverDispatcher = secretResolverDispatcher;
    }
}

