/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.service.keystoreloader;

import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.node.api.certificate.KeyStoreBundle;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.api.secrets.model.Secret;
import io.gravitee.node.api.secrets.model.SecretEvent;
import io.gravitee.node.api.secrets.model.SecretMap;
import io.gravitee.node.api.secrets.model.SecretMount;
import io.gravitee.node.secrets.service.conf.GraviteeConfigurationSecretResolverDispatcher;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretProviderKeyStoreLoader
implements KeyStoreLoader {
    private static final Logger log = LoggerFactory.getLogger(SecretProviderKeyStoreLoader.class);
    private final List<Consumer<KeyStoreBundle>> listeners = new ArrayList<Consumer<KeyStoreBundle>>();
    private final GraviteeConfigurationSecretResolverDispatcher secretResolverDispatcher;
    private final KeyStoreLoaderOptions options;
    private Disposable watch;

    public SecretProviderKeyStoreLoader(GraviteeConfigurationSecretResolverDispatcher secretResolverDispatcher, KeyStoreLoaderOptions options) {
        this.secretResolverDispatcher = secretResolverDispatcher;
        this.options = options;
    }

    public void start() {
        SecretMount secretMount = this.secretResolverDispatcher.toSecretMount(this.options.getSecretLocation());
        this.createBundleAndNotify((SecretMap)this.secretResolverDispatcher.resolve(secretMount).blockingGet(), secretMount);
        if (this.options.isWatch()) {
            this.watch = this.secretResolverDispatcher.watch(secretMount, SecretEvent.Type.UPDATED).subscribe(secretMap -> this.createBundleAndNotify((SecretMap)secretMap, secretMount), ex -> log.error("cannot create keystore", ex));
        }
    }

    private void createBundleAndNotify(SecretMap secretMap, SecretMount secretMount) {
        switch (this.options.getKeyStoreType().toUpperCase()) {
            case "PEM": {
                this.notifyListeners(new KeyStoreBundle(KeyStoreUtils.initFromPem((String)secretMap.wellKnown(SecretMap.WellKnownSecretKey.CERTIFICATE).map(Secret::asString).orElseThrow(() -> new IllegalArgumentException("no pem certificate found in secret. If a ?keymap has been set make sure it contains ?keymap=certificate:<cert key in secret data>)")), (String)secretMap.wellKnown(SecretMap.WellKnownSecretKey.PRIVATE_KEY).map(Secret::asString).orElseThrow(() -> new IllegalArgumentException("no pem private key found in secret. If a ?keymap has been set make sure it contains ?keymap=private_key:<cert key in secret data>)")), (String)this.options.getKeyStorePassword(), (String)this.options.getDefaultAlias()), this.options.getKeyStorePassword(), this.options.getDefaultAlias()));
                break;
            }
            case "JKS": 
            case "PKCS12": {
                this.notifyListeners(new KeyStoreBundle(KeyStoreUtils.initFromContent((String)this.options.getKeyStoreType(), (String)secretMap.getSecret(secretMount).map(Secret::asString).orElseThrow(() -> new IllegalArgumentException("no keystore value found for key '%s'".formatted(secretMount.key()))), (String)this.options.getKeyStorePassword()), this.options.getKeyStorePassword(), this.options.getDefaultAlias()));
                break;
            }
            default: {
                log.warn("some ssl related secrets were changes but not handled");
            }
        }
    }

    public void stop() {
        if (this.watch != null) {
            this.watch.dispose();
        }
    }

    public void addListener(Consumer<KeyStoreBundle> listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(KeyStoreBundle bundle) {
        this.listeners.forEach(c -> c.accept(bundle));
    }
}

