/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.reporter.vertx.eventbus;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusReporterWrapper
implements Reporter,
Handler<Message<Reportable>> {
    private final Logger logger = LoggerFactory.getLogger(EventBusReporterWrapper.class);
    private static final String EVENT_BUS_ADDRESS = "node:metrics";
    private final Reporter reporter;
    private final Vertx vertx;

    public EventBusReporterWrapper(Vertx vertx, Reporter reporter) {
        this.vertx = vertx;
        this.reporter = reporter;
    }

    public void report(Reportable reportable) {
    }

    public Lifecycle.State lifecycleState() {
        return this.reporter.lifecycleState();
    }

    public Object start() throws Exception {
        this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(){

            public void handle(Promise<Object> event) {
                try {
                    EventBusReporterWrapper.this.reporter.start();
                    event.complete((Object)EventBusReporterWrapper.this.reporter);
                }
                catch (Exception ex) {
                    EventBusReporterWrapper.this.logger.error("Error while starting reporter", (Throwable)ex);
                    event.fail((Throwable)ex);
                }
            }
        }, (Handler)new Handler<AsyncResult<Object>>(){

            public void handle(AsyncResult<Object> event) {
                if (event.succeeded()) {
                    EventBusReporterWrapper.this.vertx.eventBus().consumer(EventBusReporterWrapper.EVENT_BUS_ADDRESS, (Handler)EventBusReporterWrapper.this);
                }
            }
        });
        return this.reporter;
    }

    public Object stop() throws Exception {
        return this.reporter.stop();
    }

    public void handle(Message<Reportable> reportableMsg) {
        Reportable reportable = (Reportable)reportableMsg.body();
        if (this.reporter.canHandle(reportable)) {
            this.reporter.report(reportable);
        }
    }
}

