/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.core.HazelcastInstance;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.healthcheck.ProbeManager;
import io.gravitee.node.monitoring.NodeMonitoringService;
import io.gravitee.node.monitoring.handler.ClusteredNodeMonitoringEventHandler;
import io.gravitee.node.monitoring.handler.NodeMonitoringEventHandler;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckManagementEndpoint;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckService;
import io.gravitee.node.monitoring.healthcheck.ProbeManagerImpl;
import io.gravitee.node.monitoring.infos.NodeInfosService;
import io.gravitee.node.monitoring.monitor.NodeMonitorManagementEndpoint;
import io.gravitee.node.monitoring.monitor.NodeMonitorService;
import io.vertx.core.Vertx;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={NodeMonitoringService.class})
public class MonitoringConfiguration {
    @Value(value="${services.monitoring.distributed:false}")
    protected boolean distributed;

    @Bean
    public NodeMonitorService nodeMonitorService() {
        return new NodeMonitorService();
    }

    @Bean
    public NodeMonitorManagementEndpoint nodeMonitorManagementEndpoint() {
        return new NodeMonitorManagementEndpoint();
    }

    @Bean
    public NodeHealthCheckService nodeHealthCheckService() {
        return new NodeHealthCheckService();
    }

    @Bean
    public NodeHealthCheckManagementEndpoint nodeHealthCheckManagementEndpoint() {
        return new NodeHealthCheckManagementEndpoint();
    }

    @Bean
    public NodeInfosService nodeInfosService() {
        return new NodeInfosService();
    }

    @Bean
    public NodeMonitoringEventHandler nodeMonitoringEventHandler(Vertx vertx, ApplicationContext context, ObjectMapper objectMapper, Node node, NodeMonitoringService nodeMonitoringService) {
        NodeMonitoringEventHandler nodeMonitoringEventHandler = null;
        if (this.distributed) {
            try {
                ClusterManager clusterManager = (ClusterManager)context.getBean(ClusterManager.class);
                HazelcastInstance hazelcastInstance = (HazelcastInstance)context.getBean(HazelcastInstance.class);
                nodeMonitoringEventHandler = new ClusteredNodeMonitoringEventHandler(vertx, objectMapper, node, nodeMonitoringService, clusterManager, hazelcastInstance);
            }
            catch (NoClassDefFoundError | NoSuchBeanDefinitionException throwable) {
                // empty catch block
            }
        }
        if (nodeMonitoringEventHandler == null) {
            nodeMonitoringEventHandler = new NodeMonitoringEventHandler(vertx, objectMapper, node, nodeMonitoringService);
        }
        return nodeMonitoringEventHandler;
    }

    @Bean
    public ProbeManager probeManager() {
        return new ProbeManagerImpl();
    }
}

