/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.monitor.probe;

import io.gravitee.node.api.monitor.ProcessInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessProbe {
    private final Logger logger = LoggerFactory.getLogger(ProcessProbe.class);
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getMaxFileDescriptorCountField = ProcessProbe.getUnixMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorCountField = ProcessProbe.getUnixMethod("getOpenFileDescriptorCount");
    private static final Method getProcessCpuLoad = ProcessProbe.getMethod("getProcessCpuLoad");
    private static final Method getProcessCpuTime = ProcessProbe.getMethod("getProcessCpuTime");
    private static final Method getCommittedVirtualMemorySize = ProcessProbe.getMethod("getCommittedVirtualMemorySize");

    public static ProcessProbe getInstance() {
        return ProcessProbeHolder.INSTANCE;
    }

    private ProcessProbe() {
    }

    public long getMaxFileDescriptorCount() {
        if (getMaxFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        if (getOpenFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public ProcessInfo processInfo() {
        ProcessInfo info = new ProcessInfo();
        info.timestamp = System.currentTimeMillis();
        info.openFileDescriptors = this.getOpenFileDescriptorCount();
        info.maxFileDescriptors = this.getMaxFileDescriptorCount();
        info.cpu = new ProcessInfo.Cpu();
        info.cpu.percent = this.getProcessCpuPercent();
        info.cpu.total = this.getProcessCpuTotalTime();
        info.mem = new ProcessInfo.Mem();
        info.mem.totalVirtual = this.getTotalVirtualMemorySize();
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getProcessCpuPercent() {
        if (getProcessCpuLoad == null) {
        }
        try {
            double load = (Double)getProcessCpuLoad.invoke((Object)osMxBean, new Object[0]);
            if (load >= 0.0) {
                return (short)(load * 100.0);
            }
        }
        finally {
            return -1;
        }
    }

    public long getProcessCpuTotalTime() {
        if (getProcessCpuTime != null) {
            try {
                long time = (Long)getProcessCpuTime.invoke((Object)osMxBean, new Object[0]);
                if (time >= 0L) {
                    return time / 1000000L;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    public long getTotalVirtualMemorySize() {
        if (getCommittedVirtualMemorySize != null) {
            try {
                long virtual = (Long)getCommittedVirtualMemorySize.invoke((Object)osMxBean, new Object[0]);
                if (virtual >= 0L) {
                    return virtual;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method getUnixMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.UnixOperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class ProcessProbeHolder {
        private static final ProcessProbe INSTANCE = new ProcessProbe();

        private ProcessProbeHolder() {
        }
    }
}

