/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.monitor;

import io.gravitee.alert.api.event.DefaultEvent;
import io.gravitee.alert.api.event.Event;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.monitor.JvmInfo;
import io.gravitee.node.api.monitor.Monitor;
import io.gravitee.node.api.monitor.OsInfo;
import io.gravitee.node.api.monitor.ProcessInfo;
import io.gravitee.node.monitoring.monitor.probe.JvmProbe;
import io.gravitee.node.monitoring.monitor.probe.OsProbe;
import io.gravitee.node.monitoring.monitor.probe.ProcessProbe;
import io.gravitee.plugin.alert.AlertEventProducer;
import io.vertx.core.eventbus.MessageProducer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeMonitorThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMonitorThread.class);
    private final MessageProducer<Monitor> producer;
    @Autowired
    private Node node;
    @Autowired
    private AlertEventProducer eventProducer;

    public NodeMonitorThread(MessageProducer<Monitor> producer) {
        this.producer = producer;
    }

    @Override
    public void run() {
        try {
            Monitor monitor = Monitor.on((String)this.node.id()).at(System.currentTimeMillis()).os(OsProbe.getInstance().osInfo()).jvm(JvmProbe.getInstance().jvmInfo()).process(ProcessProbe.getInstance().processInfo()).build();
            this.producer.write((Object)monitor);
            if (!this.eventProducer.isEmpty()) {
                DefaultEvent.Builder event = Event.at((long)monitor.getTimestamp()).type("NODE_HEARTBEAT");
                event.property("node.id", (Object)this.node.id());
                event.property("node.hostname", (Object)this.node.hostname());
                event.property("node.application", (Object)this.node.application());
                event.organizations((Set)this.node.metadata().get("organizations"));
                event.environments((Set)this.node.metadata().get("environments"));
                OsInfo osInfo = monitor.getOs();
                event.property("os.cpu.percent", (Object)osInfo.cpu.getPercent());
                for (int i = 0; i < osInfo.cpu.getLoadAverage().length; ++i) {
                    event.property("os.cpu.average." + i, (Object)osInfo.cpu.getLoadAverage()[i]);
                }
                ProcessInfo processInfo = monitor.getProcess();
                event.property("process.fd.open", (Object)processInfo.openFileDescriptors);
                event.property("process.fd.max", (Object)processInfo.maxFileDescriptors);
                event.property("process.cpu.percent", (Object)processInfo.cpu.percent);
                event.property("process.cpu.total", (Object)processInfo.cpu.total);
                event.property("process.mem.virtual.total", (Object)processInfo.mem.totalVirtual);
                JvmInfo jvmInfo = monitor.getJvm();
                event.property("jvm.uptime", (Object)jvmInfo.uptime);
                event.property("jvm.threads.count", (Object)jvmInfo.threads.count);
                event.property("jvm.threads.peak", (Object)jvmInfo.threads.peakCount);
                event.property("jvm.mem.heap.used", (Object)jvmInfo.mem.heapUsed);
                event.property("jvm.mem.heap.max", (Object)jvmInfo.mem.heapMax);
                event.property("jvm.mem.heap.percent", (Object)jvmInfo.mem.getHeapUsedPercent());
                this.eventProducer.send(event.build());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected error occurs while monitoring the node", (Throwable)ex);
        }
    }
}

