/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.infos;

import io.gravitee.common.service.AbstractService;
import io.gravitee.common.util.Version;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.infos.NodeInfos;
import io.gravitee.node.api.infos.NodeStatus;
import io.gravitee.node.api.infos.PluginInfos;
import io.gravitee.node.monitoring.eventbus.NodeInfosCodec;
import io.gravitee.node.monitoring.monitor.probe.Constants;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.tracing.TracingPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class NodeInfosService
extends AbstractService<NodeInfosService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeInfosService.class);
    public static final String GIO_NODE_INFOS_BUS = "gio:node:infos";
    @Autowired
    private PluginRegistry pluginRegistry;
    @Autowired
    private Environment environment;
    @Autowired
    private Node node;
    @Autowired
    private Vertx vertx;
    private MessageProducer<NodeInfos> messageProducer;
    private NodeInfos nodeInfos;

    protected void doStart() throws Exception {
        LOGGER.info("Starting node infos service");
        super.doStart();
        this.messageProducer = this.vertx.eventBus().registerCodec((MessageCodec)new NodeInfosCodec()).sender(GIO_NODE_INFOS_BUS, new DeliveryOptions().setCodecName("gio:bus:codec:node_infos").setTracingPolicy(TracingPolicy.IGNORE));
        this.nodeInfos = this.buildNodeInfos();
        this.nodeInfos.setStatus(NodeStatus.STARTED);
        this.messageProducer.write((Object)this.nodeInfos);
        LOGGER.info("Start node infos service: DONE");
    }

    public NodeInfosService preStop() {
        if (this.nodeInfos == null) {
            return this;
        }
        this.nodeInfos.setStatus(NodeStatus.STOPPED);
        this.messageProducer.write((Object)this.nodeInfos);
        return this;
    }

    protected void doStop() throws Exception {
        LOGGER.info("Stopping node infos service");
        super.doStop();
        LOGGER.info("Stop node infos service : DONE");
    }

    protected String name() {
        return "Node Infos Service";
    }

    private NodeInfos buildNodeInfos() {
        NodeInfos nodeInfos = new NodeInfos();
        nodeInfos.setId(this.node.id());
        nodeInfos.setName(this.node.name());
        nodeInfos.setApplication(this.node.application());
        nodeInfos.setVersion(Version.RUNTIME_VERSION.toString());
        nodeInfos.setTags(this.getShardingTags());
        nodeInfos.setTenant(this.getTenant());
        nodeInfos.setPluginInfos(this.plugins());
        nodeInfos.setJdkVersion(Constants.JVM_NAME + " " + Constants.JVM_VERSION);
        nodeInfos.setEvaluatedAt(System.currentTimeMillis());
        try {
            nodeInfos.setPort(this.getPort());
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Could not get http server port.", (Throwable)nfe);
        }
        try {
            nodeInfos.setHostname(InetAddress.getLocalHost().getHostName());
            nodeInfos.setIp(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException uhe) {
            LOGGER.warn("Could not get hostname / IP", (Throwable)uhe);
        }
        return nodeInfos;
    }

    private Set<PluginInfos> plugins() {
        return this.pluginRegistry.plugins().stream().map(regPlugin -> {
            PluginInfos plugin = new PluginInfos();
            plugin.setId(regPlugin.id());
            plugin.setName(regPlugin.manifest().name());
            plugin.setDescription(regPlugin.manifest().description());
            plugin.setVersion(regPlugin.manifest().version());
            plugin.setType(regPlugin.type().toLowerCase());
            plugin.setPlugin(regPlugin.clazz());
            return plugin;
        }).collect(Collectors.toSet());
    }

    private List<String> getShardingTags() {
        return Arrays.asList(this.environment.getProperty("tags", "").split(","));
    }

    private String getTenant() {
        return this.environment.getProperty("tenant");
    }

    private String getZone() {
        return this.environment.getProperty("zone");
    }

    private int getPort() {
        return Integer.parseInt(this.environment.getProperty("http.port", this.environment.getProperty("jetty.port", "-1")));
    }
}

