/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.healthcheck;

import io.gravitee.alert.api.event.DefaultEvent;
import io.gravitee.alert.api.event.Event;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.healthcheck.HealthCheck;
import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.plugin.alert.AlertEventProducer;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.MessageProducer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeHealthCheckThread
implements Handler<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeHealthCheckThread.class);
    @Autowired
    private AlertEventProducer eventProducer;
    @Autowired
    private Node node;
    private long timestamp;
    private final Map<Probe, Result> results;
    private final MessageProducer<HealthCheck> producer;

    public NodeHealthCheckThread(List<Probe> probes, MessageProducer<HealthCheck> producer) {
        this.results = probes.stream().collect(Collectors.toMap(probe -> probe, probe -> Result.notReady()));
        this.producer = producer;
    }

    public void handle(Long tick) {
        this.timestamp = System.currentTimeMillis();
        for (Map.Entry<Probe, Result> probe : this.results.entrySet()) {
            try {
                probe.getKey().check().thenAccept(probe::setValue);
            }
            catch (Exception ex) {
                LOGGER.error("An error occurred when trying to evaluate health check probe {}. Switching probe to unhealthy.", (Object)probe.getKey(), (Object)ex);
                probe.setValue(Result.unhealthy((Throwable)ex));
            }
        }
        HealthCheck healthCheck = this.getHealthCheck(true);
        this.producer.write((Object)healthCheck);
        this.sendAlertEngineEvent(healthCheck);
    }

    private void sendAlertEngineEvent(HealthCheck healthCheck) {
        DefaultEvent.Builder builder = Event.now().type("NODE_HEALTHCHECK");
        builder.property("node.id", (Object)this.node.id());
        builder.property("node.hostname", (Object)this.node.hostname());
        builder.property("node.application", (Object)this.node.application());
        builder.property("node.healthy", (Object)String.valueOf(healthCheck.isHealthy()));
        builder.organizations((Set)this.node.metadata().get("organizations"));
        builder.environments((Set)this.node.metadata().get("environments"));
        healthCheck.getResults().forEach((probeId, result) -> {
            builder.property("node.probe." + probeId, (Object)result.isHealthy());
            if (!result.isHealthy()) {
                builder.property("node.probe." + probeId + ".message", (Object)result.getMessage());
            }
        });
        this.eventProducer.send(builder.build());
    }

    public HealthCheck getHealthCheck() {
        return this.getHealthCheck(false);
    }

    public HealthCheck getHealthCheck(boolean filterVisibleByDefault) {
        Map<String, Result> results = this.results.entrySet().stream().filter(entry -> !filterVisibleByDefault || ((Probe)entry.getKey()).isVisibleByDefault()).collect(Collectors.toMap(probeResultEntry -> ((Probe)probeResultEntry.getKey()).id(), Map.Entry::getValue));
        return new HealthCheck(this.timestamp, results);
    }

    public Map<Probe, Result> getResults() {
        return this.results;
    }
}

