/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.healthcheck;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.healthcheck.HealthCheck;
import io.gravitee.node.api.healthcheck.ProbeManager;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.gravitee.node.monitoring.eventbus.HealthCheckCodec;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckManagementEndpoint;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckThread;
import io.gravitee.node.monitoring.healthcheck.micrometer.NodeHealthCheckMicrometerHandler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.micrometer.backends.BackendRegistries;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeHealthCheckService
extends AbstractService {
    public static final String GIO_NODE_HEALTHCHECK_BUS = "gio:node:healthcheck";
    @Autowired
    private ManagementEndpointManager managementEndpointManager;
    @Autowired
    private ProbeManager probeManager;
    @Autowired
    private NodeHealthCheckManagementEndpoint healthCheckEndpoint;
    @Autowired
    private Vertx vertx;
    private long metricsPollerId = -1L;
    private static final long NODE_CHECKER_DELAY = 5000L;
    private MessageProducer<HealthCheck> producer;

    protected void doStart() throws Exception {
        super.doStart();
        this.producer = this.vertx.eventBus().registerCodec((MessageCodec)new HealthCheckCodec()).sender(GIO_NODE_HEALTHCHECK_BUS, new DeliveryOptions().setTracingPolicy(TracingPolicy.IGNORE).setCodecName("gio:bus:codec:node_healthcheck"));
        NodeHealthCheckThread statusRegistry = new NodeHealthCheckThread(this.probeManager.getProbes(), this.producer);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)statusRegistry);
        this.metricsPollerId = this.vertx.setPeriodic(5000L, (Handler)statusRegistry);
        this.healthCheckEndpoint.setRegistry(statusRegistry);
        this.managementEndpointManager.register((ManagementEndpoint)this.healthCheckEndpoint);
        MeterRegistry registry = BackendRegistries.getDefaultNow();
        if (registry instanceof PrometheusMeterRegistry) {
            new NodeHealthCheckMicrometerHandler(statusRegistry).bindTo(registry);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.metricsPollerId > 0L) {
            this.vertx.cancelTimer(this.metricsPollerId);
        }
        this.producer.close();
    }

    protected String name() {
        return "Node Health-check service";
    }
}

