/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Monitoring;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.healthcheck.HealthCheck;
import io.gravitee.node.api.infos.NodeInfos;
import io.gravitee.node.api.monitor.Monitor;
import io.gravitee.node.monitoring.NodeMonitoringService;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMonitoringEventHandler
extends AbstractService<NodeMonitoringEventHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMonitoringEventHandler.class);
    protected final Vertx vertx;
    protected final ObjectMapper objectMapper;
    protected final Node node;
    protected final NodeMonitoringService nodeMonitoringService;

    public NodeMonitoringEventHandler(Vertx vertx, ObjectMapper objectMapper, Node node, NodeMonitoringService nodeMonitoringService) {
        this.vertx = vertx;
        this.objectMapper = objectMapper;
        this.node = node;
        this.nodeMonitoringService = nodeMonitoringService;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.vertx.eventBus().localConsumer("gio:node:infos", this::handleNodeInfosMessage);
        this.vertx.eventBus().localConsumer("gio:node:healthcheck", this::handleHealthCheckMessage);
        this.vertx.eventBus().localConsumer("gio:node:monitor", this::handleMonitorMessage);
    }

    protected void handleNodeInfosMessage(Message<NodeInfos> message) {
        LOGGER.debug("Received node infos message from internal bus");
        this.handleNodeInfos((NodeInfos)message.body());
    }

    protected void handleHealthCheckMessage(Message<HealthCheck> message) {
        LOGGER.debug("Received health check message from internal bus");
        this.handleHealthCheck((HealthCheck)message.body());
    }

    protected void handleMonitorMessage(Message<Monitor> message) {
        LOGGER.debug("Received monitor message from internal bus");
        this.handleMonitor((Monitor)message.body());
    }

    protected void handleNodeInfos(NodeInfos nodeInfos) {
        LOGGER.debug("Received node infos message from internal bus");
        this.nodeMonitoringService.createOrUpdate(this.convert(nodeInfos)).subscribe();
    }

    protected void handleHealthCheck(HealthCheck healthCheck) {
        LOGGER.debug("Processing health check data");
        this.nodeMonitoringService.createOrUpdate(this.convert(healthCheck)).subscribe();
    }

    protected void handleMonitor(Monitor monitor) {
        LOGGER.debug("Processing monitor data");
        this.nodeMonitoringService.createOrUpdate(this.convert(monitor)).subscribe();
    }

    private Monitoring convert(NodeInfos nodeInfos) {
        Monitoring monitoring = this.buildMonitoring(nodeInfos);
        monitoring.setEvaluatedAt(new Date(nodeInfos.getEvaluatedAt()));
        monitoring.setType("NODE_INFOS");
        return monitoring;
    }

    private Monitoring convert(HealthCheck healthCheck) {
        Monitoring monitoring = this.buildMonitoring(healthCheck);
        monitoring.setEvaluatedAt(new Date(healthCheck.getEvaluatedAt()));
        monitoring.setType("HEALTH_CHECK");
        return monitoring;
    }

    private Monitoring convert(Monitor monitor) {
        Monitoring monitoring = this.buildMonitoring(monitor);
        monitoring.setEvaluatedAt(new Date(monitor.getTimestamp()));
        monitoring.setType("MONITOR");
        return monitoring;
    }

    private Monitoring buildMonitoring(Object payload) {
        Monitoring monitoring = new Monitoring();
        monitoring.setNodeId(this.node.id());
        try {
            monitoring.setPayload(this.objectMapper.writeValueAsString(payload));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurred when trying to serialize monitoring payload to json");
        }
        return monitoring;
    }
}

