/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.healthcheck.HealthCheck;
import io.gravitee.node.api.infos.NodeInfos;
import io.gravitee.node.api.monitor.Monitor;
import io.gravitee.node.monitoring.NodeMonitoringService;
import io.gravitee.node.monitoring.handler.NodeMonitoringEventHandler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredNodeMonitoringEventHandler
extends NodeMonitoringEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusteredNodeMonitoringEventHandler.class);
    private final ClusterManager clusterManager;
    private final HazelcastInstance hazelcastInstance;
    protected ITopic<HealthCheck> distributedHealthCheckTopic;
    protected ITopic<Monitor> distributedMonitorTopic;
    protected ITopic<NodeInfos> distributedNodeInfosTopic;
    private UUID healthCheckTopicListenerId;
    private UUID monitorTopicListenerId;
    private UUID nodeInfosTopicListenerId;

    public ClusteredNodeMonitoringEventHandler(Vertx vertx, ObjectMapper objectMapper, Node node, NodeMonitoringService nodeMonitoringService, ClusterManager clusterManager, HazelcastInstance hazelcastInstance) {
        super(vertx, objectMapper, node, nodeMonitoringService);
        this.clusterManager = clusterManager;
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.prepareListeners();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeListeners();
    }

    private void prepareListeners() {
        this.distributedHealthCheckTopic = this.hazelcastInstance.getReliableTopic("node-healthcheck");
        this.distributedMonitorTopic = this.hazelcastInstance.getReliableTopic("node-monitor");
        this.distributedNodeInfosTopic = this.hazelcastInstance.getReliableTopic("node-infos");
        this.healthCheckTopicListenerId = this.distributedHealthCheckTopic.addMessageListener(message -> {
            if (this.clusterManager.isMasterNode()) {
                LOGGER.debug("Received health check message from distributed topic");
                this.handleHealthCheck((HealthCheck)message.getMessageObject());
            }
        });
        this.monitorTopicListenerId = this.distributedMonitorTopic.addMessageListener(message -> {
            if (this.clusterManager.isMasterNode()) {
                LOGGER.debug("Received monitor message from distributed topic");
                this.handleMonitor((Monitor)message.getMessageObject());
            }
        });
        this.nodeInfosTopicListenerId = this.distributedNodeInfosTopic.addMessageListener(message -> {
            if (this.clusterManager.isMasterNode()) {
                LOGGER.debug("Received node infos message from distributed topic");
                this.handleNodeInfos((NodeInfos)message.getMessageObject());
            }
        });
    }

    private void removeListeners() {
        this.distributedHealthCheckTopic.removeMessageListener(this.healthCheckTopicListenerId);
        this.distributedMonitorTopic.removeMessageListener(this.monitorTopicListenerId);
        this.distributedNodeInfosTopic.removeMessageListener(this.nodeInfosTopicListenerId);
    }

    @Override
    protected void handleHealthCheckMessage(Message<HealthCheck> message) {
        LOGGER.debug("Received health check message from internal bus");
        this.distributedHealthCheckTopic.publish((Object)((HealthCheck)message.body()));
    }

    @Override
    protected void handleMonitorMessage(Message<Monitor> message) {
        LOGGER.debug("Received monitor message from internal bus");
        this.distributedMonitorTopic.publish((Object)((Monitor)message.body()));
    }

    @Override
    protected void handleNodeInfosMessage(Message<NodeInfos> message) {
        LOGGER.debug("Received health check message from internal bus");
        this.distributedNodeInfosTopic.publish((Object)((NodeInfos)message.body()));
    }
}

