/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring.eventbus;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCodec<T>
implements MessageCodec<T, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCodec.class);
    private final String codecName;

    protected AbstractCodec(String codecName) {
        this.codecName = codecName;
    }

    public void encodeToWire(Buffer buffer, T item) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(item);
            oos.flush();
            byte[] data = bos.toByteArray();
            int length = data.length;
            buffer.appendInt(length);
            buffer.appendBytes(data);
        }
        catch (Exception ex) {
            LOGGER.error("Error while trying to encode a Monitor object", (Throwable)ex);
        }
    }

    public T decodeFromWire(int position, Buffer buffer) {
        try {
            int pos = position;
            int length = buffer.getInt(pos);
            int start = pos += 4;
            int end = pos + length;
            byte[] data = buffer.getBytes(start, end);
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            return (T)is.readObject();
        }
        catch (Exception ex) {
            LOGGER.error("Error while trying to decode object using codec {}", (Object)this.codecName, (Object)ex);
            return null;
        }
    }

    public T transform(T item) {
        return item;
    }

    public String name() {
        return this.codecName;
    }

    public byte systemCodecID() {
        return -1;
    }
}

