/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.monitoring;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.Monitoring;
import io.gravitee.node.api.NodeMonitoringRepository;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class NodeMonitoringService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMonitoringService.class);
    private static final int CLEANUP_DELAY = 600000;
    private final NodeMonitoringRepository repository;
    private final Map<String, Monitoring> monitoringHolder;

    public NodeMonitoringService(@Lazy NodeMonitoringRepository repository) {
        this.repository = repository;
        this.monitoringHolder = new ConcurrentHashMap<String, Monitoring>();
    }

    public Single<Monitoring> createOrUpdate(Monitoring monitoring) {
        if (this.repository == null) {
            LOGGER.debug("There is nowhere to persist the monitoring data {}", (Object)monitoring);
            return Single.just((Object)monitoring);
        }
        String monitoringKey = monitoring.getNodeId() + monitoring.getType();
        Maybe monitoringObs = this.monitoringHolder.containsKey(monitoringKey) ? Maybe.just((Object)this.monitoringHolder.get(monitoringKey)) : this.repository.findByNodeIdAndType(monitoring.getNodeId(), monitoring.getType());
        Date now = new Date();
        return monitoringObs.flatMap(existing -> {
            monitoring.setId(existing.getId());
            monitoring.setCreatedAt(existing.getCreatedAt());
            monitoring.setUpdatedAt(now);
            return this.repository.update(monitoring).toMaybe();
        }).switchIfEmpty((SingleSource)Single.defer(() -> {
            monitoring.setId(UUID.random().toString());
            monitoring.setCreatedAt(now);
            monitoring.setUpdatedAt(now);
            return this.repository.create(monitoring);
        })).doOnSuccess(toCache -> this.monitoringHolder.put(monitoringKey, (Monitoring)toCache)).doFinally(this::cleanupMonitorHolder);
    }

    private void cleanupMonitorHolder() {
        Date cleanupDate = new Date(System.currentTimeMillis() - 600000L);
        this.monitoringHolder.entrySet().removeIf(entry -> ((Monitoring)entry.getValue()).getUpdatedAt().before(cleanupDate));
    }

    public Flowable<Monitoring> findByTypeAndTimeframe(String type, long from, long to) {
        if (this.repository == null) {
            return Flowable.empty();
        }
        return this.repository.findByTypeAndTimeFrame(type, from, to);
    }
}

