/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.node.heap;

import io.gravitee.node.management.http.node.heap.HeapDumpException;
import io.gravitee.node.management.http.node.heap.HeapDumpSupplier;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class HotSpotHeapDumpSupplier
implements HeapDumpSupplier {
    private Object diagnosticMXBean;
    private Method dumpHeapMethod;

    HotSpotHeapDumpSupplier() {
        try {
            Class diagnosticMXBeanClass = ClassUtils.resolveClassName((String)"com.sun.management.HotSpotDiagnosticMXBean", null);
            this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(diagnosticMXBeanClass);
            this.dumpHeapMethod = ReflectionUtils.findMethod((Class)diagnosticMXBeanClass, (String)"dumpHeap", (Class[])new Class[]{String.class, Boolean.TYPE});
        }
        catch (Throwable ex) {
            throw new HeapDumpException("Unable to locate HotSpotDiagnosticMXBean", ex);
        }
    }

    @Override
    public void dump(File file, boolean live) {
        ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{file.getAbsolutePath(), live});
    }
}

