/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.license.license3j;

import io.gravitee.node.api.license.Feature;
import io.gravitee.node.license.license3j.License3JFeature;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax0.license3j.License;

public class License3JLicense
implements io.gravitee.node.api.license.License {
    private static final String FEATURE_INCLUDED = "included";
    private final License license;

    public License3JLicense(License license) {
        this.license = license;
    }

    public Optional<Feature> feature(String name) {
        javax0.license3j.Feature feature = this.license == null ? null : this.license.get(name);
        return feature == null ? Optional.empty() : Optional.of(new License3JFeature(feature));
    }

    public boolean isFeatureIncluded(String featureName) {
        return this.feature(featureName).map(feature -> FEATURE_INCLUDED.equals(feature.getString())).orElse(false);
    }

    public Map<String, Object> features() {
        return this.license.getFeatures().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, new Function<Map.Entry<String, javax0.license3j.Feature>, Object>(){

            @Override
            public Object apply(Map.Entry<String, javax0.license3j.Feature> entry) {
                javax0.license3j.Feature feature = entry.getValue();
                if (feature.isBigDecimal()) {
                    return feature.getBigDecimal();
                }
                if (feature.isBigInteger()) {
                    return feature.getBigInteger();
                }
                if (feature.isBinary()) {
                    return feature.getBinary();
                }
                if (feature.isByte()) {
                    return feature.getByte();
                }
                if (feature.isDate()) {
                    return feature.getDate();
                }
                if (feature.isDouble()) {
                    return feature.getDouble();
                }
                if (feature.isFloat()) {
                    return Float.valueOf(feature.getFloat());
                }
                if (feature.isInt()) {
                    return feature.getInt();
                }
                if (feature.isLong()) {
                    return feature.getLong();
                }
                if (feature.isShort()) {
                    return feature.getShort();
                }
                if (feature.isString()) {
                    return feature.getString();
                }
                if (feature.isUUID()) {
                    return feature.getUUID();
                }
                return null;
            }
        }));
    }
}

