/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.propertyresolver;

import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.ResourceQuery;
import io.gravitee.kubernetes.client.api.WatchQuery;
import io.gravitee.kubernetes.client.model.v1.ConfigMap;
import io.gravitee.kubernetes.client.model.v1.KubernetesEventType;
import io.gravitee.kubernetes.client.model.v1.Secret;
import io.gravitee.node.kubernetes.propertyresolver.CloudScheme;
import io.gravitee.node.kubernetes.propertyresolver.PropertyResolver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class KubernetesPropertyResolver
implements PropertyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesPropertyResolver.class);
    @Autowired
    private KubernetesClient kubernetesClient;

    @Override
    public boolean supports(String currentValue) {
        Assert.notNull((Object)currentValue, (String)"Current value can not be null");
        return currentValue.startsWith(CloudScheme.KUBERNETES.value());
    }

    @Override
    public Maybe<Object> resolve(String location) {
        Assert.notNull((Object)location, (String)"Location can not be null");
        String[] properties = this.parsePropertyName(location);
        if (properties == null) {
            return Maybe.empty();
        }
        LOGGER.debug("Resolve location [{}]", (Object)location);
        if ("secrets".equals(properties[1])) {
            return this.resolvePropertyFromSecret(this.generateLocation(properties)).map(encodeData -> new String(Base64.getDecoder().decode((String)encodeData)));
        }
        if ("configmaps".equals(properties[1])) {
            return this.resolvePropertyFromConfigMap(this.generateLocation(properties)).map(String::strip);
        }
        return Maybe.error((Throwable)new RuntimeException("Property type " + properties[1] + " is not supported"));
    }

    @Override
    public Flowable<Object> watch(String location) {
        Assert.notNull((Object)location, (String)"Location can not be null");
        String[] properties = this.parsePropertyName(location);
        if (properties == null) {
            return Flowable.empty();
        }
        LOGGER.debug("Start watching location [{}]", (Object)location);
        if ("secrets".equals(properties[1])) {
            return this.kubernetesClient.watch(WatchQuery.secret((String)properties[0], (String)properties[2]).resourceKey(properties[3]).build()).filter(event -> event.getType().equals(KubernetesEventType.MODIFIED.name()) || event.getType().equals(KubernetesEventType.ADDED.name())).map(secretEvent -> {
                String encodedData = (String)((Secret)secretEvent.getObject()).getData().get(properties[3]);
                return new String(Base64.getDecoder().decode(encodedData));
            });
        }
        if ("configmaps".equals(properties[1])) {
            return this.kubernetesClient.watch(WatchQuery.configMap((String)properties[0], (String)properties[2]).resourceKey(properties[3]).build()).filter(event -> event.getType().equals(KubernetesEventType.MODIFIED.name()) || event.getType().equals(KubernetesEventType.ADDED.name())).map(configMapEvent -> ((ConfigMap)configMapEvent.getObject()).getData().get(properties[3]));
        }
        return Flowable.error((Throwable)new RuntimeException("Property type " + properties[1] + " is not supported"));
    }

    private String[] parsePropertyName(String currentValue) {
        if (!this.supports(currentValue)) {
            LOGGER.error("Does not support scheme {}", (Object)currentValue);
            return null;
        }
        String[] properties = currentValue.substring(13).split("/");
        if (properties.length != 4) {
            LOGGER.error("Wrong property value. A correct format looks like this \"kubernetes://{namespace}/configmaps/{configmap-name}/key\"");
            return null;
        }
        return properties;
    }

    private String generateLocation(String[] properties) {
        return String.format("/%s/%s/%s/%s", properties[0], properties[1], properties[2], properties[3]);
    }

    private Maybe<String> resolvePropertyFromConfigMap(String location) {
        ResourceQuery query = ResourceQuery.from((String)location).build();
        return this.kubernetesClient.get(query).flatMap(configMap -> {
            if (configMap != null) {
                return Maybe.just((Object)((String)configMap.getData().get(query.getResourceKey())));
            }
            LOGGER.warn("Key not found in this location [{}]", (Object)location);
            return Maybe.empty();
        });
    }

    private Maybe<String> resolvePropertyFromSecret(String location) {
        ResourceQuery query = ResourceQuery.from((String)location).build();
        return this.kubernetesClient.get(ResourceQuery.from((String)location).build()).flatMap(secret -> {
            if (secret != null) {
                return Maybe.just((Object)((String)secret.getData().get(query.getResourceKey())));
            }
            LOGGER.debug("Key not found in this location [{}]", (Object)location);
            return Maybe.empty();
        });
    }
}

