/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cluster.spring;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.properties.ClusterProperty;
import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.message.MessageProducer;
import io.gravitee.node.cache.hazelcast.HazelcastCacheManager;
import io.gravitee.node.cluster.hazelcast.HazelcastClusterManager;
import io.gravitee.node.cluster.hazelcast.HazelcastMessageProducer;
import io.gravitee.node.cluster.spring.ClusterConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={ClusterModeEnabled.class})
public class HazelcastClusterConfiguration {
    @Value(value="${cluster.hazelcast.config.path:${gravitee.home}/config/hazelcast.xml}")
    private String hazelcastConfigFilePath;

    @Bean
    public HazelcastInstance distributedHazelcastInstance() throws Exception {
        System.setProperty(ClusterProperty.LOGGING_TYPE.getName(), "slf4j");
        System.setProperty(ClusterProperty.SHUTDOWNHOOK_ENABLED.getName(), "false");
        FileSystemXmlConfig config = new FileSystemXmlConfig(this.hazelcastConfigFilePath);
        config.setClassLoader(ClusterConfiguration.class.getClassLoader());
        config.setProperty(ClusterProperty.HEALTH_MONITORING_LEVEL.getName(), "OFF");
        return Hazelcast.newHazelcastInstance((Config)new FileSystemXmlConfig(this.hazelcastConfigFilePath));
    }

    @Bean(value={"hazelcastClusterManager"})
    public ClusterManager hazelcastClusterManager() {
        return new HazelcastClusterManager();
    }

    @Bean(value={"hazelcastCacheManager"})
    public CacheManager hazelcastCacheManager(HazelcastInstance hazelcastInstance) {
        return new HazelcastCacheManager(hazelcastInstance);
    }

    @Bean(value={"hazelcastMessageProducer"})
    public MessageProducer hazelcastMessageProducer() {
        return new HazelcastMessageProducer();
    }

    public static class ClusterModeEnabled
    implements ConfigurationCondition {
        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return (Boolean)conditionContext.getEnvironment().getProperty("gravitee.cluster.enabled", Boolean.class, (Object)false);
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

