/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import io.gravitee.common.util.KeyStoreUtils;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableKeyManager
extends X509ExtendedKeyManager {
    private static final Logger logger = LoggerFactory.getLogger(ReloadableKeyManager.class);
    static final int MAX_SNI_DOMAINS = 10000;
    private String defaultAlias;
    private Map<String, String> sniDomainAliases;
    private volatile X509ExtendedKeyManager delegate;
    private boolean enableSni;

    public void load(String defaultAlias, KeyStore keyStore, String password, boolean enableSni) {
        try {
            this.enableSni = enableSni;
            if (defaultAlias == null) {
                defaultAlias = KeyStoreUtils.getDefaultAlias((KeyStore)keyStore);
            } else if (!keyStore.containsAlias(defaultAlias)) {
                throw new IllegalArgumentException(String.format("Unable to load keystore, default alias [%s] not present in the keystore.", defaultAlias));
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, KeyStoreUtils.passwordToCharArray((String)password));
            this.defaultAlias = defaultAlias;
            if (enableSni) {
                this.sniDomainAliases = new ConcurrentHashMap<String, String>(KeyStoreUtils.getCommonNamesByAlias((KeyStore)keyStore));
            }
            this.delegate = (X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0];
            logger.info("Key store has been (re)loaded with {} entries.", (Object)keyStore.size());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load keystore", e);
        }
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (!this.enableSni) {
            return this.defaultAlias;
        }
        ExtendedSSLSession session = (ExtendedSSLSession)engine.getHandshakeSession();
        Optional<String> optionalSNIServerName = session.getRequestedServerNames().stream().filter(name -> name.getType() == 0).map(name -> ((SNIHostName)name).getAsciiName()).findFirst();
        if (optionalSNIServerName.isPresent()) {
            String hostname = optionalSNIServerName.get();
            if (this.sniDomainAliases.containsKey(hostname)) {
                return this.sniDomainAliases.get(hostname);
            }
            Optional<Map.Entry> optCN = this.sniDomainAliases.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("*.")).filter(e -> hostname.endsWith(((String)e.getKey()).substring(2))).findFirst();
            if (optCN.isPresent()) {
                String alias = (String)optCN.get().getValue();
                this.cacheSniDomainAlias(hostname, alias);
                return alias;
            }
            this.cacheSniDomainAlias(hostname, this.defaultAlias);
            return this.defaultAlias;
        }
        return this.defaultAlias;
    }

    private void cacheSniDomainAlias(String hostname, String alias) {
        if (this.sniDomainAliases.size() < 10000) {
            this.sniDomainAliases.put(hostname, alias);
        }
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate != null ? this.delegate.getServerAliases(keyType, issuers) : null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate != null ? this.delegate.getCertificateChain(alias) : null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate != null ? this.delegate.getPrivateKey(alias) : null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate != null ? this.delegate.getClientAliases(keyType, issuers) : null;
    }

    @Override
    public String chooseClientAlias(String[] aliases, Principal[] issuers, Socket socket) {
        return this.delegate != null ? this.delegate.chooseClientAlias(aliases, issuers, socket) : null;
    }

    @Override
    public String chooseServerAlias(String alias, Principal[] issuers, Socket socket) {
        return this.delegate != null ? this.delegate.chooseServerAlias(alias, issuers, socket) : null;
    }

    Map<String, String> getSniDomainAliases() {
        return this.sniDomainAliases;
    }

    void setSniDomainAliases(Map<String, String> sniDomainAliases) {
        this.sniDomainAliases = sniDomainAliases;
    }
}

