/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderFactory;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.certificates.FileKeyStoreLoader;
import java.util.Arrays;
import java.util.List;

public class FileKeyStoreLoaderFactory
implements KeyStoreLoaderFactory {
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("JKS".toLowerCase(), "PEM".toLowerCase(), "PKCS12".toLowerCase());

    public boolean canHandle(KeyStoreLoaderOptions options) {
        return options.getKeyStoreType() != null && SUPPORTED_TYPES.contains(options.getKeyStoreType().toLowerCase()) && (options.getKeyStorePath() != null && !options.getKeyStorePath().isEmpty() || options.getKeyStoreCertificates() != null && !options.getKeyStoreCertificates().isEmpty());
    }

    public KeyStoreLoader create(KeyStoreLoaderOptions options) {
        return new FileKeyStoreLoader(options);
    }
}

