/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import io.gravitee.node.api.certificate.CertificateManager;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.certificates.ReloadableKeyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BaseCertificateManager
implements CertificateManager {
    protected boolean enableSni;
    protected final ReloadableKeyManager keyManager;
    protected final List<KeyStoreLoader> keyStoreLoaders;

    public BaseCertificateManager(boolean enableSni) {
        this.enableSni = enableSni;
        this.keyManager = new ReloadableKeyManager();
        this.keyStoreLoaders = new ArrayList<KeyStoreLoader>();
    }

    public void registerLoader(KeyStoreLoader keyStoreLoader) {
        Objects.requireNonNull(keyStoreLoader, "KeyStoreLoader cannot be null");
        this.keyStoreLoaders.add(keyStoreLoader);
        keyStoreLoader.addListener(keyStoreBundle -> {
            try {
                this.keyManager.load(keyStoreBundle.getDefaultAlias(), keyStoreBundle.getKeyStore(), keyStoreBundle.getPassword(), this.enableSni);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load the keystore", e);
            }
        });
    }
}

