/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cache.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapListenerAdapter;
import com.hazelcast.map.listener.MapListener;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.api.cache.CacheListener;
import io.gravitee.node.api.cache.EntryEventType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class HazelcastCache<K, V>
implements Cache<K, V> {
    private final IMap<K, V> cache;
    private final Map<CacheListener<K, V>, UUID> listeners = new HashMap<CacheListener<K, V>, UUID>();
    private final long timeToLiveMillis;

    public HazelcastCache(IMap<K, V> cache, CacheConfiguration configuration) {
        this.cache = cache;
        this.timeToLiveMillis = configuration.getTimeToLiveSeconds();
    }

    public String getName() {
        return this.cache.getName();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public Collection<V> values() {
        return this.cache.values();
    }

    public V get(K key) {
        return (V)this.cache.get(key);
    }

    public V put(K key, V value) {
        return (V)this.cache.put(key, value);
    }

    public V put(K key, V value, long ttl, TimeUnit ttlUnit) {
        long ttlMillis = TimeUnit.MILLISECONDS.convert(ttl, ttlUnit);
        if (this.timeToLiveMillis > 0L && ttlMillis > this.timeToLiveMillis) {
            throw new RuntimeException("single ttl can't be bigger than ttl defined in the configuration");
        }
        return (V)this.cache.put(key, value, ttlMillis, TimeUnit.MILLISECONDS);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    public V evict(K key) {
        Object v = this.cache.get(key);
        this.cache.remove(key);
        return (V)v;
    }

    public void clear() {
        this.cache.clear();
    }

    public void addCacheListener(final CacheListener<K, V> cacheListener) {
        UUID id = this.cache.addEntryListener((MapListener)new MapListenerAdapter<K, V>(){

            public void onEntryEvent(EntryEvent<K, V> event) {
                cacheListener.onEvent(new io.gravitee.node.api.cache.EntryEvent(event.getSource(), EntryEventType.getByType((int)event.getEventType().getType()), event.getKey(), event.getOldValue(), event.getValue()));
            }
        }, true);
        this.listeners.put(cacheListener, id);
    }

    public boolean removeCacheListener(CacheListener<K, V> cacheListener) {
        UUID id = this.listeners.remove(cacheListener);
        if (id != null) {
            return this.cache.removeEntryListener(id);
        }
        return false;
    }
}

