/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.secrets.model;

import io.gravitee.node.api.secrets.model.Secret;
import io.gravitee.node.api.secrets.model.SecretMount;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SecretMap {
    private final Map<String, Secret> map;
    private final Map<WellKnownSecretKey, Secret> wellKnown = new EnumMap<WellKnownSecretKey, Secret>(WellKnownSecretKey.class);
    private final Instant expireAt;

    public SecretMap(Map<String, Secret> map) {
        this(map, null);
    }

    public SecretMap(Map<String, Secret> map, Instant expireAt) {
        this.map = map == null ? Map.of() : Map.copyOf(map);
        this.expireAt = expireAt;
    }

    public static SecretMap ofBase64(Map<String, ?> data) {
        return new SecretMap(SecretMap.mapToMap(data, true));
    }

    public static SecretMap ofBase64(Map<String, ?> data, Instant expireAt) {
        return new SecretMap(SecretMap.mapToMap(data, true), expireAt);
    }

    public static SecretMap of(Map<String, ?> data) {
        return new SecretMap(SecretMap.mapToMap(data, false));
    }

    public static SecretMap of(Map<String, ?> data, Instant expireAt) {
        return new SecretMap(SecretMap.mapToMap(data, false), expireAt);
    }

    private static Map<String, Secret> mapToMap(Map<String, ?> data, boolean base64) {
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Secret(e.getValue(), base64)));
    }

    public Optional<Secret> getSecret(SecretMount secretMount) {
        return Optional.ofNullable(this.map.get(secretMount.key()));
    }

    public Optional<Instant> expireAt() {
        return Optional.ofNullable(this.expireAt);
    }

    public SecretMap handleWellKnownSecretKeys(Map<String, WellKnownSecretKey> mapping) {
        this.map.entrySet().stream().filter(entry -> mapping.get(entry.getKey()) != null).forEach(entry -> this.wellKnown.put((WellKnownSecretKey)((Object)((Object)mapping.get(entry.getKey()))), (Secret)entry.getValue()));
        return this;
    }

    public Optional<Secret> wellKnown(WellKnownSecretKey key) {
        return Optional.ofNullable(this.wellKnown.get((Object)key));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretMap)) {
            return false;
        }
        SecretMap other = (SecretMap)o;
        Map<String, Secret> this$map = this.map;
        Map<String, Secret> other$map = other.map;
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        Map<WellKnownSecretKey, Secret> this$wellKnown = this.wellKnown;
        Map<WellKnownSecretKey, Secret> other$wellKnown = other.wellKnown;
        if (this$wellKnown == null ? other$wellKnown != null : !((Object)this$wellKnown).equals(other$wellKnown)) {
            return false;
        }
        Instant this$expireAt = this.expireAt;
        Instant other$expireAt = other.expireAt;
        return !(this$expireAt == null ? other$expireAt != null : !((Object)this$expireAt).equals(other$expireAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Secret> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        Map<WellKnownSecretKey, Secret> $wellKnown = this.wellKnown;
        result = result * 59 + ($wellKnown == null ? 43 : ((Object)$wellKnown).hashCode());
        Instant $expireAt = this.expireAt;
        result = result * 59 + ($expireAt == null ? 43 : ((Object)$expireAt).hashCode());
        return result;
    }

    public static enum WellKnownSecretKey {
        CERTIFICATE,
        PRIVATE_KEY,
        USERNAME,
        PASSWORD;

    }
}

