/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.secrets.model;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class Secret {
    private final Object data;
    private final boolean base64Encoded;

    public Secret(Object data) {
        this(data, false);
    }

    public Secret(Object data, boolean base64Encoded) {
        if (!(data instanceof String) && !(data instanceof byte[])) {
            throw new IllegalArgumentException("secret can only be of type String or byte[] and must not be null");
        }
        this.data = data;
        this.base64Encoded = base64Encoded;
    }

    public boolean isEmpty() {
        boolean result = true;
        Object object = this.data;
        if (object instanceof String) {
            String str = (String)object;
            result = str.isEmpty();
        } else {
            object = this.data;
            if (object instanceof byte[]) {
                byte[] buf = (byte[])object;
                result = buf.length == 0;
            }
        }
        return result;
    }

    public byte[] asBytes() {
        byte[] result = new byte[]{};
        Object object = this.data;
        if (object instanceof String) {
            String str = (String)object;
            byte[] byArray = result = this.base64Encoded ? Base64.getDecoder().decode(str) : str.getBytes(StandardCharsets.UTF_8);
        }
        if ((object = this.data) instanceof byte[]) {
            byte[] buf = (byte[])object;
            result = this.base64Encoded ? Base64.getDecoder().decode(buf) : buf;
        }
        return result;
    }

    public String asString() {
        String result = "";
        Object object = this.data;
        if (object instanceof String) {
            String str = (String)object;
            String string = result = this.base64Encoded ? new String(Base64.getDecoder().decode(str)) : str;
        }
        if ((object = this.data) instanceof byte[]) {
            byte[] buf = (byte[])object;
            result = this.base64Encoded ? new String(Base64.getDecoder().decode(buf)) : new String(buf, StandardCharsets.UTF_8);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret other = (Secret)o;
        if (this.base64Encoded != other.base64Encoded) {
            return false;
        }
        Object this$data = this.data;
        Object other$data = other.data;
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.base64Encoded ? 79 : 97);
        Object $data = this.data;
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

