/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.license.model;

import io.gravitee.node.api.license.model.LicensePack;
import io.gravitee.node.api.license.model.LicenseTier;
import java.util.Map;

public class LicenseModel {
    private Map<String, LicensePack> packs;
    private Map<String, LicenseTier> tiers;

    public boolean isGraviteeTier(String tierName) {
        return this.tiers.containsKey(tierName);
    }

    public boolean isGraviteePack(String packName) {
        return this.packs.keySet().stream().anyMatch(pack -> pack.equals(packName));
    }

    public boolean isGraviteeFeature(String featureName) {
        return this.packs.values().stream().anyMatch(pack -> pack.getFeatures().contains(featureName));
    }

    public Map<String, LicensePack> getPacks() {
        return this.packs;
    }

    public Map<String, LicenseTier> getTiers() {
        return this.tiers;
    }

    public void setPacks(Map<String, LicensePack> packs) {
        this.packs = packs;
    }

    public void setTiers(Map<String, LicenseTier> tiers) {
        this.tiers = tiers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseModel)) {
            return false;
        }
        LicenseModel other = (LicenseModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, LicensePack> this$packs = this.getPacks();
        Map<String, LicensePack> other$packs = other.getPacks();
        if (this$packs == null ? other$packs != null : !((Object)this$packs).equals(other$packs)) {
            return false;
        }
        Map<String, LicenseTier> this$tiers = this.getTiers();
        Map<String, LicenseTier> other$tiers = other.getTiers();
        return !(this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LicenseModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, LicensePack> $packs = this.getPacks();
        result = result * 59 + ($packs == null ? 43 : ((Object)$packs).hashCode());
        Map<String, LicenseTier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        return result;
    }

    public String toString() {
        return "LicenseModel(packs=" + this.getPacks() + ", tiers=" + this.getTiers() + ")";
    }
}

