/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.certificate;

import io.gravitee.node.api.certificate.CertificateOptions;
import java.util.List;

public class KeyStoreLoaderOptions {
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private List<String> kubernetesLocations;
    private String secretLocation;
    private List<CertificateOptions> keyStoreCertificates;
    private boolean watch = true;
    private String defaultAlias = null;

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public List<CertificateOptions> getKeyStoreCertificates() {
        return this.keyStoreCertificates;
    }

    public void setKeyStoreCertificates(List<CertificateOptions> keyStoreCertificates) {
        this.keyStoreCertificates = keyStoreCertificates;
    }

    public List<String> getKubernetesLocations() {
        return this.kubernetesLocations;
    }

    public void setKubernetesLocations(List<String> kubernetesLocations) {
        this.kubernetesLocations = kubernetesLocations;
    }

    public String getSecretLocation() {
        return this.secretLocation;
    }

    public void setSecretLocation(String secretLocation) {
        this.secretLocation = secretLocation;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String getDefaultAlias() {
        return this.defaultAlias;
    }

    public void setDefaultAlias(String defaultAlias) {
        this.defaultAlias = defaultAlias;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private KeyStoreLoaderOptions keyStoreLoaderOptions = new KeyStoreLoaderOptions();

        private Builder() {
        }

        public Builder withKeyStorePath(String keyStorePath) {
            this.keyStoreLoaderOptions.setKeyStorePath(keyStorePath);
            return this;
        }

        public Builder withKeyStorePassword(String keyStorePassword) {
            this.keyStoreLoaderOptions.setKeyStorePassword(keyStorePassword);
            return this;
        }

        public Builder withKeyStoreType(String keyStoreType) {
            this.keyStoreLoaderOptions.setKeyStoreType(keyStoreType);
            return this;
        }

        public Builder withKubernetesLocations(List<String> kubernetesLocations) {
            this.keyStoreLoaderOptions.setKubernetesLocations(kubernetesLocations);
            return this;
        }

        public Builder withSecretLocation(String secretLocation) {
            this.keyStoreLoaderOptions.setSecretLocation(secretLocation);
            return this;
        }

        public Builder withKeyStoreCertificates(List<CertificateOptions> keyStoreCertificates) {
            this.keyStoreLoaderOptions.setKeyStoreCertificates(keyStoreCertificates);
            return this;
        }

        public Builder withWatch(boolean watch) {
            this.keyStoreLoaderOptions.setWatch(watch);
            return this;
        }

        public Builder withDefaultAlias(String defaultAlias) {
            this.keyStoreLoaderOptions.setDefaultAlias(defaultAlias);
            return this;
        }

        public KeyStoreLoaderOptions build() {
            return this.keyStoreLoaderOptions;
        }
    }
}

