/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.monitor;

import java.io.Serializable;

public class OsInfo
implements Serializable {
    public long timestamp;
    public Cpu cpu = null;
    public Mem mem = null;
    public Swap swap = null;

    private static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Swap
    implements Serializable {
        public long total = -1L;
        public long free = -1L;
    }

    public static class Mem
    implements Serializable {
        public long total = -1L;
        public long free = -1L;

        public long getTotal() {
            return this.total;
        }

        public long getUsed() {
            return this.total - this.free;
        }

        public short getUsedPercent() {
            return OsInfo.calculatePercentage(this.getUsed(), this.getTotal());
        }

        public long getFree() {
            return this.free;
        }

        public short getFreePercent() {
            return OsInfo.calculatePercentage(this.getFree(), this.getTotal());
        }
    }

    public static class Cpu
    implements Serializable {
        public short percent = (short)-1;
        public double[] loadAverage = null;

        public short getPercent() {
            return this.percent;
        }

        public double[] getLoadAverage() {
            return this.loadAverage;
        }
    }
}

