/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.deployer;

import io.gravitee.node.api.license.License;
import io.gravitee.node.api.plugin.NodeDeploymentContext;
import io.gravitee.plugin.api.PluginDeploymentLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginDeploymentLifecycle
implements PluginDeploymentLifecycle<NodeDeploymentContext> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract String getFeatureName();

    public boolean isDeployable(NodeDeploymentContext context) {
        License license = context.node().license();
        boolean deployable = false;
        if (license != null) {
            deployable = license.isFeatureIncluded(this.getFeatureName());
        }
        if (!deployable) {
            this.logger.warn("Feature {} is missing from the license", (Object)this.getFeatureName());
        }
        return deployable;
    }
}

