/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.healthcheck;

import java.io.Serializable;

public class Result
implements Serializable {
    private static final Result HEALTHY = new Result(true, null);
    private static final Result NOT_READY = new Result(false, "not ready");
    private static final int PRIME = 31;
    private final boolean healthy;
    private final String message;

    public Result() {
        this.healthy = true;
        this.message = null;
    }

    protected Result(boolean isHealthy, String message) {
        this.healthy = isHealthy;
        this.message = message;
    }

    public static Result unhealthy(Throwable error) {
        return new Result(false, error.getMessage());
    }

    public static Result unhealthy(String message) {
        return new Result(false, message);
    }

    public static Result unhealthy(String message, Object ... args) {
        return Result.unhealthy(String.format(message, args));
    }

    public static Result healthy(String message, Object ... args) {
        return Result.healthy(String.format(message, args));
    }

    public static Result healthy(String message) {
        return new Result(true, message);
    }

    public static Result healthy() {
        return HEALTHY;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public static Result notReady() {
        return NOT_READY;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.healthy == result.healthy && !(this.message == null ? result.message != null : !this.message.equals(result.message));
    }

    public int hashCode() {
        int result = this.healthy ? 1 : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Result{isHealthy=");
        builder.append(this.healthy);
        if (this.message != null) {
            builder.append(", message=").append(this.message);
        }
        builder.append('}');
        return builder.toString();
    }
}

