/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.spring;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.event.impl.EventManagerImpl;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.management.fetcher.spring.FetcherConfigurationConfiguration;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.PasswordValidator;
import io.gravitee.management.service.impl.search.configuration.SearchEngineConfiguration;
import io.gravitee.management.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.management.service.impl.swagger.policy.impl.PolicyOperationVisitorManagerImpl;
import io.gravitee.management.service.jackson.filter.ApiPermissionFilter;
import io.gravitee.management.service.jackson.ser.api.ApiCompositeSerializer;
import io.gravitee.management.service.jackson.ser.api.ApiSerializer;
import io.gravitee.management.service.quality.ApiQualityMetricLoader;
import io.gravitee.management.service.validator.RegexPasswordValidator;
import io.gravitee.plugin.alert.spring.AlertPluginConfiguration;
import io.gravitee.plugin.discovery.spring.ServiceDiscoveryPluginConfiguration;
import io.gravitee.plugin.fetcher.spring.FetcherPluginConfiguration;
import io.gravitee.plugin.notifier.spring.NotifierPluginConfiguration;
import io.gravitee.plugin.policy.spring.PolicyPluginConfiguration;
import io.gravitee.plugin.resource.spring.ResourcePluginConfiguration;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"io.gravitee.management.service"})
@EnableTransactionManagement
@Import(value={PolicyPluginConfiguration.class, ResourcePluginConfiguration.class, FetcherPluginConfiguration.class, FetcherConfigurationConfiguration.class, SearchEngineConfiguration.class, NotifierPluginConfiguration.class, AlertPluginConfiguration.class, ServiceDiscoveryPluginConfiguration.class})
public class ServiceConfiguration {
    @Bean
    public EventManager eventManager() {
        return new EventManagerImpl();
    }

    @Bean
    public ObjectMapper objectMapper() {
        GraviteeMapper objectMapper = new GraviteeMapper();
        ApiPermissionFilter apiMembershipTypeFilter = new ApiPermissionFilter();
        objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider(Collections.singletonMap("apiMembershipTypeFilter", apiMembershipTypeFilter)));
        objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        SimpleModule module = new SimpleModule();
        module.addSerializer(ApiEntity.class, (JsonSerializer)this.apiSerializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    @Bean
    public ApiQualityMetricLoader apiQualityMetricLoader() {
        return new ApiQualityMetricLoader();
    }

    @Bean
    public ApiSerializer apiSerializer() {
        return new ApiCompositeSerializer();
    }

    @Bean
    public PolicyOperationVisitorManager policyVisitorManager() {
        return new PolicyOperationVisitorManagerImpl();
    }

    @Bean
    public PasswordValidator passwordValidator() {
        return new RegexPasswordValidator();
    }
}

