/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.spring;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ImportConfiguration
implements InitializingBean {
    @Value(value="${imports.allow-from-private:true}")
    private boolean allowImportFromPrivate;
    private List<String> importWhitelist;
    @Autowired
    private Environment environment;

    public void afterPropertiesSet() {
        String whitelistUrl;
        int i = 0;
        this.importWhitelist = new ArrayList<String>();
        while ((whitelistUrl = this.environment.getProperty("imports.whitelist[" + i + "]")) != null) {
            this.importWhitelist.add(whitelistUrl);
            ++i;
        }
    }

    public boolean isAllowImportFromPrivate() {
        return this.allowImportFromPrivate;
    }

    public List<String> getImportWhitelist() {
        return this.importWhitelist;
    }
}

