/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.sanitizer;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import io.gravitee.management.service.sanitizer.AllowAllSanitizer;
import org.apache.commons.lang3.StringUtils;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public final class HtmlSanitizer {
    private static final Parser mdParser = Parser.builder((DataHolder)new MutableDataSet()).build();
    private static final HtmlRenderer htmlRenderer = HtmlRenderer.builder((DataHolder)new MutableDataSet()).build();
    private static final PolicyFactory factory = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(Sanitizers.IMAGES).and(new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).toFactory()).and(Sanitizers.STYLES).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"pre", "hr"}).toFactory()).and(new HtmlPolicyBuilder().allowElements(new String[]{"img"}).allowAttributes(new String[]{"title"}).globally().toFactory()).and(new HtmlPolicyBuilder().allowElements(new String[]{"code"}).allowAttributes(new String[]{"class"}).globally().toFactory());

    private HtmlSanitizer() {
    }

    public static String sanitize(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return factory.sanitize(content);
    }

    public static SanitizeInfos isSafe(String content) {
        if (content == null || content.isEmpty()) {
            return new SanitizeInfos(true);
        }
        String toSanitize = htmlRenderer.render((Node)mdParser.parse(content));
        String initialHtml = AllowAllSanitizer.sanitize(toSanitize);
        String sanitizedHtml = HtmlSanitizer.sanitize(toSanitize);
        String[] initialLines = initialHtml.split("\n");
        String[] sanitizedLines = sanitizedHtml.split("\n");
        String diffMessage = null;
        for (int i = 0; i < initialLines.length; ++i) {
            if (i < sanitizedLines.length) {
                String difference = StringUtils.difference((String)sanitizedLines[i], (String)initialLines[i]);
                if (!difference.isEmpty()) {
                    diffMessage = "The content [" + difference + "] is not allowed (~line " + (i + 1) + ")";
                }
            } else {
                diffMessage = "The content [" + initialLines[i] + "] is not allowed";
            }
            if (diffMessage != null) break;
        }
        if (diffMessage == null) {
            return new SanitizeInfos(true);
        }
        return new SanitizeInfos(false, diffMessage);
    }

    public static class SanitizeInfos {
        boolean safe;
        String rejectedMessage;

        public SanitizeInfos(boolean safe) {
            this.safe = safe;
        }

        public SanitizeInfos(boolean safe, String rejectedMessage) {
            this.safe = safe;
            this.rejectedMessage = rejectedMessage;
        }

        public boolean isSafe() {
            return this.safe;
        }

        public String getRejectedMessage() {
            return this.rejectedMessage;
        }
    }
}

