/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.quality;

import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.service.quality.ApiQualityMetric;

public class ApiQualityMetricHealthcheck
implements ApiQualityMetric {
    @Override
    public Key getWeightKey() {
        return Key.API_QUALITY_METRICS_HEALTHCHECK_WEIGHT;
    }

    @Override
    public boolean isValid(ApiEntity api) {
        boolean globalHC;
        boolean bl = globalHC = api.getServices() != null && api.getServices().getAll() != null && api.getServices().getAll().stream().anyMatch(service -> service.isEnabled() && service instanceof HealthCheckService);
        if (globalHC) {
            return true;
        }
        return api.getProxy().getGroups().stream().allMatch(group -> group.getEndpoints().stream().allMatch(endpoint -> {
            if (endpoint instanceof HttpEndpoint) {
                return ((HttpEndpoint)endpoint).getHealthCheck() != null && ((HttpEndpoint)endpoint).getHealthCheck().isEnabled();
            }
            return false;
        }));
    }
}

