/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.management.model.DeploymentRequired;
import io.gravitee.management.model.api.ApiEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiSynchronizationProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(ApiSynchronizationProcessor.class);
    @Autowired
    private ObjectMapper objectMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processCheckSynchronization(ApiEntity deployedApi, ApiEntity apiToDeploy) {
        Class<ApiEntity> cl = ApiEntity.class;
        ArrayList<Object> requiredFieldsDeployedApi = new ArrayList<Object>();
        ArrayList<Object> requiredFieldsApiToDeploy = new ArrayList<Object>();
        for (Field f : cl.getDeclaredFields()) {
            if (f.getAnnotation(DeploymentRequired.class) == null) continue;
            boolean previousAccessibleState = f.isAccessible();
            f.setAccessible(true);
            try {
                requiredFieldsDeployedApi.add(f.get(deployedApi));
                requiredFieldsApiToDeploy.add(f.get(apiToDeploy));
            }
            catch (Exception e) {
                this.LOGGER.error("Error access API required deployment fields", (Throwable)e);
            }
            finally {
                f.setAccessible(previousAccessibleState);
            }
        }
        try {
            String requiredFieldsDeployedApiDefinition = this.objectMapper.writeValueAsString(requiredFieldsDeployedApi);
            String requiredFieldsApiToDeployDefinition = this.objectMapper.writeValueAsString(requiredFieldsApiToDeploy);
            return requiredFieldsDeployedApiDefinition.equals(requiredFieldsApiToDeployDefinition);
        }
        catch (Exception e) {
            this.LOGGER.error("Unexpected error while generating API deployment required fields definition", (Throwable)e);
            return false;
        }
    }
}

