/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.notification;

import io.gravitee.management.service.notification.Hook;
import io.gravitee.management.service.notification.HookScope;

public enum ApiHook implements Hook
{
    APIKEY_EXPIRED("API key Expired", "Triggered when an API key is expired.", "API KEY"),
    APIKEY_RENEWED("API key Renewed", "Triggered when an API key is renewed.", "API KEY"),
    APIKEY_REVOKED("API key Revoked", "Triggered when an API key is revoked.", "API KEY"),
    SUBSCRIPTION_NEW("New Subscription", "Triggered when a Subscription is created.", "SUBSCRIPTION"),
    SUBSCRIPTION_ACCEPTED("Subscription Accepted", "Triggered when a Subscription is accepted.", "SUBSCRIPTION"),
    SUBSCRIPTION_CLOSED("Subscription Closed", "Triggered when a Subscription is closed.", "SUBSCRIPTION"),
    SUBSCRIPTION_PAUSED("Subscription Paused", "Triggered when a Subscription is paused.", "SUBSCRIPTION"),
    SUBSCRIPTION_RESUMED("Subscription Resumed", "Triggered when a Subscription is resumed.", "SUBSCRIPTION"),
    SUBSCRIPTION_REJECTED("Subscription Rejected", "Triggered when a Subscription is rejected.", "SUBSCRIPTION"),
    SUBSCRIPTION_TRANSFERRED("Subscription Transferred", "Triggered when a Subscription is transferred.", "SUBSCRIPTION"),
    NEW_SUPPORT_TICKET("New Support Ticket", "Triggered when a new support ticket is created", "SUPPORT"),
    API_STARTED("API Started", "Triggered when an API is started", "LIFECYCLE"),
    API_STOPPED("API Stopped", "Triggered when an API is stopped", "LIFECYCLE"),
    NEW_RATING("New Rating", "Triggered when a new rating is submitted", "RATING"),
    NEW_RATING_ANSWER("New Rating Answer", "Triggered when a new answer is submitted", "RATING"),
    MESSAGE(null, null, null, true),
    ASK_FOR_REVIEW("Ask for API review", "Triggered when an API can be reviewed", "REVIEW"),
    REVIEW_OK("Accept API review", "Triggered when an API's review has been accepted", "REVIEW"),
    REQUEST_FOR_CHANGES("Reject API review", "Triggered when an API's review has been rejected", "REVIEW"),
    API_DEPRECATED("API Deprecated", "Triggered when an API is deprecated", "LIFECYCLE");

    private String label;
    private String description;
    private String category;
    private boolean hidden;

    private ApiHook(String label, String description, String category) {
        this(label, description, category, false);
    }

    private ApiHook(String label, String description, String category, boolean hidden) {
        this.label = label;
        this.description = description;
        this.category = category;
        this.hidden = hidden;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public HookScope getScope() {
        return HookScope.API;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

