/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.ResponseTemplates;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.jackson.ser.api.ApiSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class Api1_25VersionSerializer
extends ApiSerializer {
    public Api1_25VersionSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, final JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        if (apiEntity.getPathMappings() != null) {
            jsonGenerator.writeArrayFieldStart("path_mappings");
            apiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    jsonGenerator.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProxy() != null) {
            jsonGenerator.writeObjectFieldStart("proxy");
            Iterator virtualHostIterator = apiEntity.getProxy().getVirtualHosts().iterator();
            if (virtualHostIterator.hasNext()) {
                jsonGenerator.writeObjectField("context_path", (Object)((VirtualHost)virtualHostIterator.next()).getPath());
            }
            jsonGenerator.writeObjectField("strip_context_path", (Object)apiEntity.getProxy().isStripContextPath());
            if (apiEntity.getProxy().getLogging() != null) {
                jsonGenerator.writeObjectField("logging", (Object)apiEntity.getProxy().getLogging());
            }
            jsonGenerator.writeArrayFieldStart("groups");
            apiEntity.getProxy().getGroups().forEach(new Consumer<EndpointGroup>(){

                @Override
                public void accept(EndpointGroup endpointGroup) {
                    try {
                        jsonGenerator.writeObject((Object)endpointGroup);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            jsonGenerator.writeEndArray();
            if (apiEntity.getProxy().getFailover() != null) {
                jsonGenerator.writeObjectField("failover", (Object)apiEntity.getProxy().getFailover());
            }
            if (apiEntity.getProxy().getCors() != null) {
                jsonGenerator.writeObjectField("cors", (Object)apiEntity.getProxy().getCors());
            }
            jsonGenerator.writeEndObject();
        }
        if (apiEntity.getResponseTemplates() != null) {
            jsonGenerator.writeObjectFieldStart("response_templates");
            for (Map.Entry rt : apiEntity.getResponseTemplates().entrySet()) {
                jsonGenerator.writeObjectFieldStart((String)rt.getKey());
                for (Map.Entry entry : ((ResponseTemplates)rt.getValue()).getTemplates().entrySet()) {
                    jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.V_1_25;
    }
}

