/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.management.service.Upgrader;
import io.gravitee.management.service.ViewService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ViewRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.View;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultViewUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultViewUpgrader.class);
    @Autowired
    private ViewService viewService;
    @Autowired
    private ViewRepository viewRepository;
    @Autowired
    private ApiRepository apiRepository;

    @Override
    public boolean upgrade() {
        try {
            Set views = this.viewRepository.findAll();
            Optional<View> optionalAllView = views.stream().filter(v -> v.getId().equals("all")).findFirst();
            if (optionalAllView.isPresent()) {
                String key = optionalAllView.get().getKey();
                if (key == null || key.isEmpty()) {
                    this.logger.info("Update views to add field key");
                    for (View view2 : views) {
                        view2.setKey(IdGenerator.generate((String)view2.getName()));
                        this.viewRepository.update((Object)view2);
                    }
                    for (Api api : this.apiRepository.search(null)) {
                        Set apiViews = api.getViews();
                        if (apiViews != null) {
                            HashSet newApiViews = new HashSet(apiViews.size());
                            for (String apiView : apiViews) {
                                Optional<View> optionalView = views.stream().filter(v -> apiView.equals(v.getId())).findAny();
                                optionalView.ifPresent(view -> newApiViews.add(view.getId()));
                            }
                            api.setViews(newApiViews);
                        }
                        this.apiRepository.update((Object)api);
                    }
                }
            } else {
                this.logger.info("Create default View");
                this.viewService.createDefaultView();
            }
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

