/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.management.model.NewRoleEntity;
import io.gravitee.management.model.permissions.ApiPermission;
import io.gravitee.management.model.permissions.ApplicationPermission;
import io.gravitee.management.model.permissions.ManagementPermission;
import io.gravitee.management.model.permissions.PortalPermission;
import io.gravitee.management.model.permissions.RolePermissionAction;
import io.gravitee.management.model.permissions.RoleScope;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.Upgrader;
import io.gravitee.management.service.exceptions.RoleNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultRolesUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultRolesUpgrader.class);
    @Autowired
    private RoleService roleService;

    @Override
    public boolean upgrade() {
        if (this.roleService.findAll().isEmpty()) {
            this.logger.info("    No role found. Add default ones.");
            HashMap<String, char[]> perms = new HashMap<String, char[]>();
            this.logger.info("     - <MANAGEMENT> API_PUBLISHER");
            perms.put(ManagementPermission.API.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ManagementPermission.APPLICATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ManagementPermission.TAG.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.GROUP.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.TENANT.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.ROLE.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.PLATFORM.getName(), new char[]{RolePermissionAction.READ.getId()});
            this.roleService.create(new NewRoleEntity("API_PUBLISHER", "Management Role. Created by Gravitee.io.", RoleScope.MANAGEMENT, false, perms));
            this.logger.info("     - <MANAGEMENT> USER (default)");
            perms.clear();
            perms.put(ManagementPermission.API.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.APPLICATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ManagementPermission.ROLE.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ManagementPermission.GROUP.getName(), new char[]{RolePermissionAction.READ.getId()});
            this.roleService.create(new NewRoleEntity("USER", "Default Management Role. Created by Gravitee.io.", RoleScope.MANAGEMENT, true, perms));
            this.logger.info("     - <PORTAL> USER (default)");
            perms.clear();
            perms.put(PortalPermission.APPLICATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(PortalPermission.DOCUMENTATION.getName(), new char[]{RolePermissionAction.READ.getId()});
            this.roleService.create(new NewRoleEntity("USER", "Default Portal Role. Created by Gravitee.io.", RoleScope.PORTAL, true, perms));
            this.logger.info("     - <API> USER (default)");
            perms.clear();
            perms.put(ApiPermission.DEFINITION.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.PLAN.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.SUBSCRIPTION.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.MEMBER.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.METADATA.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.EVENT.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.DOCUMENTATION.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApiPermission.RATING.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId()});
            this.roleService.create(new NewRoleEntity("USER", "Default API Role. Created by Gravitee.io.", RoleScope.API, true, perms));
            this.logger.info("     - <API> OWNER");
            perms.clear();
            perms.put(ApiPermission.DEFINITION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.GATEWAY_DEFINITION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.PLAN.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.SUBSCRIPTION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.MEMBER.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.METADATA.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.ANALYTICS.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.EVENT.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.HEALTH.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.LOG.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.DOCUMENTATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.AUDIT.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.RATING.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.RATING_ANSWER.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.DISCOVERY.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.NOTIFICATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApiPermission.ALERT.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            this.roleService.create(new NewRoleEntity("OWNER", "API Role. Created by Gravitee.io.", RoleScope.API, false, perms));
            this.createRoleApiReviewer(perms);
            this.logger.info("     - <APPLICATION> USER (default)");
            perms.clear();
            perms.put(ApplicationPermission.DEFINITION.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApplicationPermission.MEMBER.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApplicationPermission.ANALYTICS.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApplicationPermission.LOG.getName(), new char[]{RolePermissionAction.READ.getId()});
            perms.put(ApplicationPermission.SUBSCRIPTION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId()});
            perms.put(ApplicationPermission.METADATA.getName(), new char[]{RolePermissionAction.READ.getId()});
            this.roleService.create(new NewRoleEntity("USER", "Default Application Role. Created by Gravitee.io.", RoleScope.APPLICATION, true, perms));
            this.logger.info("     - <APPLICATION> OWNER");
            perms.clear();
            perms.put(ApplicationPermission.DEFINITION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.MEMBER.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.ANALYTICS.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.LOG.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.SUBSCRIPTION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.NOTIFICATION.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.ALERT.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            perms.put(ApplicationPermission.METADATA.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            this.roleService.create(new NewRoleEntity("OWNER", "Default Application Role. Created by Gravitee.io.", RoleScope.APPLICATION, false, perms));
        } else {
            try {
                this.roleService.findById(io.gravitee.repository.management.model.RoleScope.API, "REVIEWER");
            }
            catch (RoleNotFoundException rnfe) {
                this.createRoleApiReviewer(new HashMap<String, char[]>());
            }
        }
        this.roleService.createOrUpdateSystemRoles();
        return true;
    }

    private void createRoleApiReviewer(Map<String, char[]> perms) {
        this.logger.info("     - <API> REVIEWER");
        perms.clear();
        perms.put(ApiPermission.DEFINITION.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.GATEWAY_DEFINITION.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.PLAN.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.METADATA.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.DOCUMENTATION.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.DISCOVERY.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.NOTIFICATION.getName(), new char[]{RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId()});
        perms.put(ApiPermission.ALERT.getName(), new char[]{RolePermissionAction.READ.getId()});
        perms.put(ApiPermission.REVIEWS.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
        this.roleService.create(new NewRoleEntity("REVIEWER", "API Role. Created by Gravitee.io.", RoleScope.API, false, perms));
    }

    @Override
    public int getOrder() {
        return 150;
    }
}

