/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.management.model.MetadataEntity;
import io.gravitee.management.model.MetadataFormat;
import io.gravitee.management.model.NewMetadataEntity;
import io.gravitee.management.service.MetadataService;
import io.gravitee.management.service.Upgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetadataUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultMetadataUpgrader.class);
    public static final String METADATA_EMAIL_SUPPORT_KEY = "email-support";
    public static final String DEFAULT_METADATA_EMAIL_SUPPORT = "support@change.me";
    @Autowired
    private MetadataService metadataService;

    @Override
    public boolean upgrade() {
        MetadataEntity defaultEmailSupportMetadata = this.metadataService.findDefaultByKey(METADATA_EMAIL_SUPPORT_KEY);
        if (defaultEmailSupportMetadata == null) {
            this.logger.info("    No default metadata for email support found. Add default one.");
            NewMetadataEntity metadata = new NewMetadataEntity();
            metadata.setFormat(MetadataFormat.MAIL);
            metadata.setName("Email support");
            metadata.setValue(DEFAULT_METADATA_EMAIL_SUPPORT);
            MetadataEntity metadataEntity = this.metadataService.create(metadata);
            this.logger.info("    Added default metadata for email support with success: {}", (Object)metadataEntity);
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

