/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.management.model.DashboardEntity;
import io.gravitee.management.model.DashboardReferenceType;
import io.gravitee.management.model.NewDashboardEntity;
import io.gravitee.management.service.DashboardService;
import io.gravitee.management.service.Upgrader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultDashboardsUpgrader
implements Upgrader,
Ordered {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultDashboardsUpgrader.class);
    @Autowired
    private DashboardService dashboardService;

    @Override
    public boolean upgrade() {
        List<DashboardEntity> dashboards = this.dashboardService.findAll();
        if (dashboards == null || dashboards.isEmpty()) {
            this.checkAndCreateDashboard(io.gravitee.repository.management.model.DashboardReferenceType.PLATFORM);
            this.checkAndCreateDashboard(io.gravitee.repository.management.model.DashboardReferenceType.API);
            this.checkAndCreateDashboard(io.gravitee.repository.management.model.DashboardReferenceType.APPLICATION);
        }
        return true;
    }

    private void checkAndCreateDashboard(io.gravitee.repository.management.model.DashboardReferenceType referenceType) {
        this.LOGGER.info("    No default {}'s dashboards, creating default ones...", (Object)referenceType);
        this.createDashboard(referenceType, "Global");
        this.createDashboard(referenceType, "Geo");
        this.createDashboard(referenceType, "User");
        this.LOGGER.info("    Added default {}'s dashboards with success", (Object)referenceType);
    }

    private void createDashboard(io.gravitee.repository.management.model.DashboardReferenceType referenceType, String prefixName) {
        NewDashboardEntity dashboard = new NewDashboardEntity();
        dashboard.setName(prefixName + " dashboard");
        dashboard.setReferenceId("DEFAULT");
        dashboard.setReferenceType(DashboardReferenceType.valueOf((String)referenceType.name()));
        dashboard.setEnabled(true);
        String filePath = String.format("/dashboards/%s_%s.json", referenceType.name().toLowerCase(), prefixName.toLowerCase());
        try {
            dashboard.setDefinition(IOUtils.toString((InputStream)this.getClass().getResourceAsStream(filePath), (Charset)Charset.defaultCharset()));
        }
        catch (Exception e) {
            this.LOGGER.error("Error while trying to create a dashboard from the definition path: " + filePath, (Throwable)e);
        }
        this.dashboardService.create(dashboard);
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

