/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.swagger.transformer.entrypoints;

import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.api.ApiEntrypointEntity;
import io.gravitee.management.service.impl.swagger.transformer.page.AbstractPageConfigurationSwaggerTransformer;
import io.gravitee.management.service.swagger.OAIDescriptor;
import io.swagger.v3.oas.models.servers.Server;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class EntrypointsOAITransformer
extends AbstractPageConfigurationSwaggerTransformer<OAIDescriptor> {
    private final List<ApiEntrypointEntity> entrypoints;

    public EntrypointsOAITransformer(PageEntity page, List<ApiEntrypointEntity> entrypoints) {
        super(page);
        this.entrypoints = entrypoints;
    }

    @Override
    public void transform(OAIDescriptor descriptor) {
        if (this.asBoolean("entrypointsAsServers") && this.entrypoints != null && !this.entrypoints.isEmpty()) {
            ArrayList servers = new ArrayList();
            this.entrypoints.forEach(entrypoint -> {
                Server server = new Server();
                if (this.getProperty("entrypointAsBasePath") == null || this.getProperty("entrypointAsBasePath").isEmpty() || this.asBoolean("entrypointAsBasePath")) {
                    server.setUrl(entrypoint.getTarget());
                } else {
                    URI target = URI.create(entrypoint.getTarget());
                    server.setUrl(entrypoint.getTarget().substring(0, entrypoint.getTarget().indexOf(target.getRawPath())));
                }
                servers.add(server);
            });
            descriptor.getSpecification().setServers(servers);
        }
    }
}

