/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.swagger.parser;

import io.gravitee.management.service.exceptions.SwaggerDescriptorException;
import io.gravitee.management.service.impl.swagger.parser.AbstractSwaggerParser;
import io.gravitee.management.service.swagger.OAIDescriptor;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIParser
extends AbstractSwaggerParser<OAIDescriptor> {
    private final Logger logger = LoggerFactory.getLogger(OAIParser.class);

    @Override
    public OAIDescriptor parse(String content) {
        SwaggerParseResult parseResult;
        OpenAPIParser parser = new OpenAPIParser();
        String path = content;
        if (!OAIParser.isLocationUrl(content)) {
            File temp = this.createTempFile(content);
            path = temp.getAbsolutePath();
        }
        if ((parseResult = parser.readLocation(path, null, null)) == null || parseResult.getOpenAPI() == null) {
            throw new SwaggerDescriptorException("Malformed descriptor");
        }
        OAIDescriptor descriptor = new OAIDescriptor(parseResult.getOpenAPI());
        descriptor.setMessages(parseResult.getMessages());
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(String content) {
        File temp = null;
        String fileName = "gio_swagger_" + System.currentTimeMillis();
        BufferedWriter bw = null;
        FileWriter out = null;
        try {
            temp = File.createTempFile(fileName, ".tmp");
            out = new FileWriter(temp);
            bw = new BufferedWriter(out);
            bw.write(content);
            bw.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return temp;
    }

    static {
        System.setProperty(String.format("%s.trustAll", RemoteUrl.class.getName()), Boolean.TRUE.toString());
    }
}

